/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TierLevel {
    BASIC("BASIC"),
    STANDARD("STANDARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TierLevel> VALUE_MAP;
    private final String value;

    private TierLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TierLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TierLevel> knownValues() {
        EnumSet<TierLevel> knownValues = EnumSet.allOf(TierLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TierLevel.class, TierLevel::toString);
    }
}

