/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.repostspace.RepostspaceClient;
import software.amazon.awssdk.services.repostspace.internal.UserAgentUtils;
import software.amazon.awssdk.services.repostspace.model.ListSpacesRequest;
import software.amazon.awssdk.services.repostspace.model.ListSpacesResponse;
import software.amazon.awssdk.services.repostspace.model.SpaceData;

public class ListSpacesIterable
implements SdkIterable<ListSpacesResponse> {
    private final RepostspaceClient client;
    private final ListSpacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSpacesIterable(RepostspaceClient client, ListSpacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSpacesResponseFetcher();
    }

    public Iterator<ListSpacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpaceData> spaces() {
        Function<ListSpacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.spaces() != null) {
                return response.spaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSpacesResponseFetcher
    implements SyncPageFetcher<ListSpacesResponse> {
        private ListSpacesResponseFetcher() {
        }

        public boolean hasNextPage(ListSpacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSpacesResponse nextPage(ListSpacesResponse previousPage) {
            if (previousPage == null) {
                return ListSpacesIterable.this.client.listSpaces(ListSpacesIterable.this.firstRequest);
            }
            return ListSpacesIterable.this.client.listSpaces((ListSpacesRequest)((Object)ListSpacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

