/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.repostspace.DefaultRepostspaceClientBuilder;
import software.amazon.awssdk.services.repostspace.RepostspaceClientBuilder;
import software.amazon.awssdk.services.repostspace.RepostspaceServiceClientConfiguration;
import software.amazon.awssdk.services.repostspace.model.AccessDeniedException;
import software.amazon.awssdk.services.repostspace.model.ConflictException;
import software.amazon.awssdk.services.repostspace.model.CreateSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.CreateSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.DeregisterAdminRequest;
import software.amazon.awssdk.services.repostspace.model.DeregisterAdminResponse;
import software.amazon.awssdk.services.repostspace.model.GetSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.GetSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.InternalServerException;
import software.amazon.awssdk.services.repostspace.model.ListSpacesRequest;
import software.amazon.awssdk.services.repostspace.model.ListSpacesResponse;
import software.amazon.awssdk.services.repostspace.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.repostspace.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.repostspace.model.RegisterAdminRequest;
import software.amazon.awssdk.services.repostspace.model.RegisterAdminResponse;
import software.amazon.awssdk.services.repostspace.model.RepostspaceException;
import software.amazon.awssdk.services.repostspace.model.ResourceNotFoundException;
import software.amazon.awssdk.services.repostspace.model.SendInvitesRequest;
import software.amazon.awssdk.services.repostspace.model.SendInvitesResponse;
import software.amazon.awssdk.services.repostspace.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.repostspace.model.TagResourceRequest;
import software.amazon.awssdk.services.repostspace.model.TagResourceResponse;
import software.amazon.awssdk.services.repostspace.model.ThrottlingException;
import software.amazon.awssdk.services.repostspace.model.UntagResourceRequest;
import software.amazon.awssdk.services.repostspace.model.UntagResourceResponse;
import software.amazon.awssdk.services.repostspace.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.repostspace.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.repostspace.model.ValidationException;
import software.amazon.awssdk.services.repostspace.paginators.ListSpacesIterable;

@SdkPublicApi
@ThreadSafe
public interface RepostspaceClient
extends AwsClient {
    public static final String SERVICE_NAME = "repostspace";
    public static final String SERVICE_METADATA_ID = "repostspace";

    default public CreateSpaceResponse createSpace(CreateSpaceRequest createSpaceRequest) throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public CreateSpaceResponse createSpace(Consumer<CreateSpaceRequest.Builder> createSpaceRequest) throws ServiceQuotaExceededException, AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.createSpace((CreateSpaceRequest)((Object)((CreateSpaceRequest.Builder)CreateSpaceRequest.builder().applyMutation(createSpaceRequest)).build()));
    }

    default public DeleteSpaceResponse deleteSpace(DeleteSpaceRequest deleteSpaceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public DeleteSpaceResponse deleteSpace(Consumer<DeleteSpaceRequest.Builder> deleteSpaceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.deleteSpace((DeleteSpaceRequest)((Object)((DeleteSpaceRequest.Builder)DeleteSpaceRequest.builder().applyMutation(deleteSpaceRequest)).build()));
    }

    default public DeregisterAdminResponse deregisterAdmin(DeregisterAdminRequest deregisterAdminRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public DeregisterAdminResponse deregisterAdmin(Consumer<DeregisterAdminRequest.Builder> deregisterAdminRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.deregisterAdmin((DeregisterAdminRequest)((Object)((DeregisterAdminRequest.Builder)DeregisterAdminRequest.builder().applyMutation(deregisterAdminRequest)).build()));
    }

    default public GetSpaceResponse getSpace(GetSpaceRequest getSpaceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public GetSpaceResponse getSpace(Consumer<GetSpaceRequest.Builder> getSpaceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.getSpace((GetSpaceRequest)((Object)((GetSpaceRequest.Builder)GetSpaceRequest.builder().applyMutation(getSpaceRequest)).build()));
    }

    default public ListSpacesResponse listSpaces(ListSpacesRequest listSpacesRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public ListSpacesResponse listSpaces(Consumer<ListSpacesRequest.Builder> listSpacesRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.listSpaces((ListSpacesRequest)((Object)((ListSpacesRequest.Builder)ListSpacesRequest.builder().applyMutation(listSpacesRequest)).build()));
    }

    default public ListSpacesIterable listSpacesPaginator(ListSpacesRequest listSpacesRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return new ListSpacesIterable(this, listSpacesRequest);
    }

    default public ListSpacesIterable listSpacesPaginator(Consumer<ListSpacesRequest.Builder> listSpacesRequest) throws AccessDeniedException, ValidationException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.listSpacesPaginator((ListSpacesRequest)((Object)((ListSpacesRequest.Builder)ListSpacesRequest.builder().applyMutation(listSpacesRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public RegisterAdminResponse registerAdmin(RegisterAdminRequest registerAdminRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public RegisterAdminResponse registerAdmin(Consumer<RegisterAdminRequest.Builder> registerAdminRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.registerAdmin((RegisterAdminRequest)((Object)((RegisterAdminRequest.Builder)RegisterAdminRequest.builder().applyMutation(registerAdminRequest)).build()));
    }

    default public SendInvitesResponse sendInvites(SendInvitesRequest sendInvitesRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public SendInvitesResponse sendInvites(Consumer<SendInvitesRequest.Builder> sendInvitesRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.sendInvites((SendInvitesRequest)((Object)((SendInvitesRequest.Builder)SendInvitesRequest.builder().applyMutation(sendInvitesRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws AccessDeniedException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public UpdateSpaceResponse updateSpace(UpdateSpaceRequest updateSpaceRequest) throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        throw new UnsupportedOperationException();
    }

    default public UpdateSpaceResponse updateSpace(Consumer<UpdateSpaceRequest.Builder> updateSpaceRequest) throws AccessDeniedException, ConflictException, ValidationException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RepostspaceException {
        return this.updateSpace((UpdateSpaceRequest)((Object)((UpdateSpaceRequest.Builder)UpdateSpaceRequest.builder().applyMutation(updateSpaceRequest)).build()));
    }

    public static RepostspaceClient create() {
        return (RepostspaceClient)RepostspaceClient.builder().build();
    }

    public static RepostspaceClientBuilder builder() {
        return new DefaultRepostspaceClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"repostspace");
    }

    default public RepostspaceServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

