/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLakehouseConfigurationRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<UpdateLakehouseConfigurationRequest.Builder, UpdateLakehouseConfigurationRequest> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("catalogName").getter(getter(UpdateLakehouseConfigurationRequest::catalogName))
            .setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogName").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dryRun").getter(getter(UpdateLakehouseConfigurationRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()).build();

    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("lakehouseIdcApplicationArn")
            .getter(getter(UpdateLakehouseConfigurationRequest::lakehouseIdcApplicationArn))
            .setter(setter(Builder::lakehouseIdcApplicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcApplicationArn").build())
            .build();

    private static final SdkField<String> LAKEHOUSE_IDC_REGISTRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lakehouseIdcRegistration")
            .getter(getter(UpdateLakehouseConfigurationRequest::lakehouseIdcRegistrationAsString))
            .setter(setter(Builder::lakehouseIdcRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcRegistration").build())
            .build();

    private static final SdkField<String> LAKEHOUSE_REGISTRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lakehouseRegistration")
            .getter(getter(UpdateLakehouseConfigurationRequest::lakehouseRegistrationAsString))
            .setter(setter(Builder::lakehouseRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseRegistration").build())
            .build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(UpdateLakehouseConfigurationRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD,
            DRY_RUN_FIELD, LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, LAKEHOUSE_IDC_REGISTRATION_FIELD, LAKEHOUSE_REGISTRATION_FIELD,
            NAMESPACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogName;

    private final Boolean dryRun;

    private final String lakehouseIdcApplicationArn;

    private final String lakehouseIdcRegistration;

    private final String lakehouseRegistration;

    private final String namespaceName;

    private UpdateLakehouseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.catalogName = builder.catalogName;
        this.dryRun = builder.dryRun;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.lakehouseIdcRegistration = builder.lakehouseIdcRegistration;
        this.lakehouseRegistration = builder.lakehouseRegistration;
        this.namespaceName = builder.namespaceName;
    }

    /**
     * <p>
     * The name of the Glue Data Catalog that will be associated with the namespace enabled with Amazon Redshift
     * federated permissions.
     * </p>
     * <p>
     * Pattern: <code>^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$</code>
     * </p>
     * 
     * @return The name of the Glue Data Catalog that will be associated with the namespace enabled with Amazon Redshift
     *         federated permissions.</p>
     *         <p>
     *         Pattern: <code>^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$</code>
     */
    public final String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * A boolean value that, if <code>true</code>, validates the request without actually updating the lakehouse
     * configuration. Use this to check for errors before making changes.
     * </p>
     * 
     * @return A boolean value that, if <code>true</code>, validates the request without actually updating the lakehouse
     *         configuration. Use this to check for errors before making changes.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web Services IAM
     * Identity Center trusted identity propagation on a namespace enabled with Amazon Redshift federated permissions.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web
     *         Services IAM Identity Center trusted identity propagation on a namespace enabled with Amazon Redshift
     *         federated permissions.
     */
    public final String lakehouseIdcApplicationArn() {
        return lakehouseIdcApplicationArn;
    }

    /**
     * <p>
     * Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled with
     * Amazon Redshift federated permissions. Valid values are <code>Associate</code> or <code>Disassociate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakehouseIdcRegistration} will return {@link LakehouseIdcRegistration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #lakehouseIdcRegistrationAsString}.
     * </p>
     * 
     * @return Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled
     *         with Amazon Redshift federated permissions. Valid values are <code>Associate</code> or
     *         <code>Disassociate</code>.
     * @see LakehouseIdcRegistration
     */
    public final LakehouseIdcRegistration lakehouseIdcRegistration() {
        return LakehouseIdcRegistration.fromValue(lakehouseIdcRegistration);
    }

    /**
     * <p>
     * Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled with
     * Amazon Redshift federated permissions. Valid values are <code>Associate</code> or <code>Disassociate</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakehouseIdcRegistration} will return {@link LakehouseIdcRegistration#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #lakehouseIdcRegistrationAsString}.
     * </p>
     * 
     * @return Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled
     *         with Amazon Redshift federated permissions. Valid values are <code>Associate</code> or
     *         <code>Disassociate</code>.
     * @see LakehouseIdcRegistration
     */
    public final String lakehouseIdcRegistrationAsString() {
        return lakehouseIdcRegistration;
    }

    /**
     * <p>
     * Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions. Valid
     * values are <code>Register</code> or <code>Deregister</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakehouseRegistration} will return {@link LakehouseRegistration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lakehouseRegistrationAsString}.
     * </p>
     * 
     * @return Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions.
     *         Valid values are <code>Register</code> or <code>Deregister</code>.
     * @see LakehouseRegistration
     */
    public final LakehouseRegistration lakehouseRegistration() {
        return LakehouseRegistration.fromValue(lakehouseRegistration);
    }

    /**
     * <p>
     * Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions. Valid
     * values are <code>Register</code> or <code>Deregister</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lakehouseRegistration} will return {@link LakehouseRegistration#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lakehouseRegistrationAsString}.
     * </p>
     * 
     * @return Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions.
     *         Valid values are <code>Register</code> or <code>Deregister</code>.
     * @see LakehouseRegistration
     */
    public final String lakehouseRegistrationAsString() {
        return lakehouseRegistration;
    }

    /**
     * <p>
     * The name of the namespace whose lakehouse configuration you want to modify.
     * </p>
     * 
     * @return The name of the namespace whose lakehouse configuration you want to modify.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(lakehouseIdcRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lakehouseRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLakehouseConfigurationRequest)) {
            return false;
        }
        UpdateLakehouseConfigurationRequest other = (UpdateLakehouseConfigurationRequest) obj;
        return Objects.equals(catalogName(), other.catalogName()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn())
                && Objects.equals(lakehouseIdcRegistrationAsString(), other.lakehouseIdcRegistrationAsString())
                && Objects.equals(lakehouseRegistrationAsString(), other.lakehouseRegistrationAsString())
                && Objects.equals(namespaceName(), other.namespaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLakehouseConfigurationRequest").add("CatalogName", catalogName()).add("DryRun", dryRun())
                .add("LakehouseIdcApplicationArn", lakehouseIdcApplicationArn())
                .add("LakehouseIdcRegistration", lakehouseIdcRegistrationAsString())
                .add("LakehouseRegistration", lakehouseRegistrationAsString()).add("NamespaceName", namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "catalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "dryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "lakehouseIdcApplicationArn":
            return Optional.ofNullable(clazz.cast(lakehouseIdcApplicationArn()));
        case "lakehouseIdcRegistration":
            return Optional.ofNullable(clazz.cast(lakehouseIdcRegistrationAsString()));
        case "lakehouseRegistration":
            return Optional.ofNullable(clazz.cast(lakehouseRegistrationAsString()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("catalogName", CATALOG_NAME_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        map.put("lakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("lakehouseIdcRegistration", LAKEHOUSE_IDC_REGISTRATION_FIELD);
        map.put("lakehouseRegistration", LAKEHOUSE_REGISTRATION_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLakehouseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLakehouseConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLakehouseConfigurationRequest> {
        /**
         * <p>
         * The name of the Glue Data Catalog that will be associated with the namespace enabled with Amazon Redshift
         * federated permissions.
         * </p>
         * <p>
         * Pattern: <code>^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$</code>
         * </p>
         * 
         * @param catalogName
         *        The name of the Glue Data Catalog that will be associated with the namespace enabled with Amazon
         *        Redshift federated permissions.</p>
         *        <p>
         *        Pattern: <code>^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * A boolean value that, if <code>true</code>, validates the request without actually updating the lakehouse
         * configuration. Use this to check for errors before making changes.
         * </p>
         * 
         * @param dryRun
         *        A boolean value that, if <code>true</code>, validates the request without actually updating the
         *        lakehouse configuration. Use this to check for errors before making changes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web Services
         * IAM Identity Center trusted identity propagation on a namespace enabled with Amazon Redshift federated
         * permissions.
         * </p>
         * 
         * @param lakehouseIdcApplicationArn
         *        The Amazon Resource Name (ARN) of the IAM Identity Center application used for enabling Amazon Web
         *        Services IAM Identity Center trusted identity propagation on a namespace enabled with Amazon Redshift
         *        federated permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn);

        /**
         * <p>
         * Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled with
         * Amazon Redshift federated permissions. Valid values are <code>Associate</code> or <code>Disassociate</code>.
         * </p>
         * 
         * @param lakehouseIdcRegistration
         *        Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace
         *        enabled with Amazon Redshift federated permissions. Valid values are <code>Associate</code> or
         *        <code>Disassociate</code>.
         * @see LakehouseIdcRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakehouseIdcRegistration
         */
        Builder lakehouseIdcRegistration(String lakehouseIdcRegistration);

        /**
         * <p>
         * Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace enabled with
         * Amazon Redshift federated permissions. Valid values are <code>Associate</code> or <code>Disassociate</code>.
         * </p>
         * 
         * @param lakehouseIdcRegistration
         *        Modifies the Amazon Web Services IAM Identity Center trusted identity propagation on a namespace
         *        enabled with Amazon Redshift federated permissions. Valid values are <code>Associate</code> or
         *        <code>Disassociate</code>.
         * @see LakehouseIdcRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakehouseIdcRegistration
         */
        Builder lakehouseIdcRegistration(LakehouseIdcRegistration lakehouseIdcRegistration);

        /**
         * <p>
         * Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions. Valid
         * values are <code>Register</code> or <code>Deregister</code>.
         * </p>
         * 
         * @param lakehouseRegistration
         *        Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions.
         *        Valid values are <code>Register</code> or <code>Deregister</code>.
         * @see LakehouseRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakehouseRegistration
         */
        Builder lakehouseRegistration(String lakehouseRegistration);

        /**
         * <p>
         * Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions. Valid
         * values are <code>Register</code> or <code>Deregister</code>.
         * </p>
         * 
         * @param lakehouseRegistration
         *        Specifies whether to register or deregister the namespace with Amazon Redshift federated permissions.
         *        Valid values are <code>Register</code> or <code>Deregister</code>.
         * @see LakehouseRegistration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LakehouseRegistration
         */
        Builder lakehouseRegistration(LakehouseRegistration lakehouseRegistration);

        /**
         * <p>
         * The name of the namespace whose lakehouse configuration you want to modify.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace whose lakehouse configuration you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String catalogName;

        private Boolean dryRun;

        private String lakehouseIdcApplicationArn;

        private String lakehouseIdcRegistration;

        private String lakehouseRegistration;

        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLakehouseConfigurationRequest model) {
            super(model);
            catalogName(model.catalogName);
            dryRun(model.dryRun);
            lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            lakehouseIdcRegistration(model.lakehouseIdcRegistration);
            lakehouseRegistration(model.lakehouseRegistration);
            namespaceName(model.namespaceName);
        }

        public final String getCatalogName() {
            return catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final String getLakehouseIdcRegistration() {
            return lakehouseIdcRegistration;
        }

        public final void setLakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
        }

        @Override
        public final Builder lakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseIdcRegistration(LakehouseIdcRegistration lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration(lakehouseIdcRegistration == null ? null : lakehouseIdcRegistration.toString());
            return this;
        }

        public final String getLakehouseRegistration() {
            return lakehouseRegistration;
        }

        public final void setLakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
        }

        @Override
        public final Builder lakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseRegistration(LakehouseRegistration lakehouseRegistration) {
            this.lakehouseRegistration(lakehouseRegistration == null ? null : lakehouseRegistration.toString());
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLakehouseConfigurationRequest build() {
            return new UpdateLakehouseConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
