/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an
 * example of a target action.
 * </p>
 * <p>
 * <code>"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetAction implements SdkPojo, Serializable, ToCopyableBuilder<TargetAction.Builder, TargetAction> {
    private static final SdkField<CreateSnapshotScheduleActionParameters> CREATE_SNAPSHOT_FIELD = SdkField
            .<CreateSnapshotScheduleActionParameters> builder(MarshallingType.SDK_POJO).memberName("createSnapshot")
            .getter(getter(TargetAction::createSnapshot)).setter(setter(Builder::createSnapshot))
            .constructor(CreateSnapshotScheduleActionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_SNAPSHOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateSnapshotScheduleActionParameters createSnapshot;

    private final Type type;

    private TargetAction(BuilderImpl builder) {
        this.createSnapshot = builder.createSnapshot;
        this.type = builder.type;
    }

    /**
     * Returns the value of the CreateSnapshot property for this object.
     * 
     * @return The value of the CreateSnapshot property for this object.
     */
    public final CreateSnapshotScheduleActionParameters createSnapshot() {
        return createSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetAction)) {
            return false;
        }
        TargetAction other = (TargetAction) obj;
        return Objects.equals(createSnapshot(), other.createSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetAction").add("CreateSnapshot", createSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createSnapshot":
            return Optional.ofNullable(clazz.cast(createSnapshot()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #createSnapshot()} initialized to the given value.
     *
     * Sets the value of the CreateSnapshot property for this object.
     *
     * @param createSnapshot
     *        The new value for the CreateSnapshot property for this object.
     */
    public static TargetAction fromCreateSnapshot(CreateSnapshotScheduleActionParameters createSnapshot) {
        return builder().createSnapshot(createSnapshot).build();
    }

    /**
     * Create an instance of this class with {@link #createSnapshot()} initialized to the given value.
     *
     * Sets the value of the CreateSnapshot property for this object.
     *
     * @param createSnapshot
     *        The new value for the CreateSnapshot property for this object.
     */
    public static TargetAction fromCreateSnapshot(Consumer<CreateSnapshotScheduleActionParameters.Builder> createSnapshot) {
        CreateSnapshotScheduleActionParameters.Builder builder = CreateSnapshotScheduleActionParameters.builder();
        createSnapshot.accept(builder);
        return fromCreateSnapshot(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createSnapshot", CREATE_SNAPSHOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetAction, T> g) {
        return obj -> g.apply((TargetAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetAction> {
        /**
         * Sets the value of the CreateSnapshot property for this object.
         *
         * @param createSnapshot
         *        The new value for the CreateSnapshot property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSnapshot(CreateSnapshotScheduleActionParameters createSnapshot);

        /**
         * Sets the value of the CreateSnapshot property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CreateSnapshotScheduleActionParameters.Builder} avoiding the need to create one manually via
         * {@link CreateSnapshotScheduleActionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateSnapshotScheduleActionParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #createSnapshot(CreateSnapshotScheduleActionParameters)}.
         * 
         * @param createSnapshot
         *        a consumer that will call methods on {@link CreateSnapshotScheduleActionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createSnapshot(CreateSnapshotScheduleActionParameters)
         */
        default Builder createSnapshot(Consumer<CreateSnapshotScheduleActionParameters.Builder> createSnapshot) {
            return createSnapshot(CreateSnapshotScheduleActionParameters.builder().applyMutation(createSnapshot).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateSnapshotScheduleActionParameters createSnapshot;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TargetAction model) {
            createSnapshot(model.createSnapshot);
        }

        public final CreateSnapshotScheduleActionParameters.Builder getCreateSnapshot() {
            return createSnapshot != null ? createSnapshot.toBuilder() : null;
        }

        public final void setCreateSnapshot(CreateSnapshotScheduleActionParameters.BuilderImpl createSnapshot) {
            Object oldValue = this.createSnapshot;
            this.createSnapshot = createSnapshot != null ? createSnapshot.build() : null;
            handleUnionValueChange(Type.CREATE_SNAPSHOT, oldValue, this.createSnapshot);
        }

        @Override
        public final Builder createSnapshot(CreateSnapshotScheduleActionParameters createSnapshot) {
            Object oldValue = this.createSnapshot;
            this.createSnapshot = createSnapshot;
            handleUnionValueChange(Type.CREATE_SNAPSHOT, oldValue, this.createSnapshot);
            return this;
        }

        @Override
        public TargetAction build() {
            return new TargetAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TargetAction#type()
     */
    public enum Type {
        CREATE_SNAPSHOT,

        UNKNOWN_TO_SDK_VERSION
    }
}
