/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSnapshotCopyConfigurationsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListSnapshotCopyConfigurationsResponse.Builder, ListSnapshotCopyConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSnapshotCopyConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SnapshotCopyConfiguration>> SNAPSHOT_COPY_CONFIGURATIONS_FIELD = SdkField
            .<List<SnapshotCopyConfiguration>> builder(MarshallingType.LIST)
            .memberName("snapshotCopyConfigurations")
            .getter(getter(ListSnapshotCopyConfigurationsResponse::snapshotCopyConfigurations))
            .setter(setter(Builder::snapshotCopyConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SnapshotCopyConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotCopyConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SNAPSHOT_COPY_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SnapshotCopyConfiguration> snapshotCopyConfigurations;

    private ListSnapshotCopyConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.snapshotCopyConfigurations = builder.snapshotCopyConfigurations;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotCopyConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSnapshotCopyConfigurations() {
        return snapshotCopyConfigurations != null && !(snapshotCopyConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All of the returned snapshot copy configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotCopyConfigurations} method.
     * </p>
     * 
     * @return All of the returned snapshot copy configurations.
     */
    public final List<SnapshotCopyConfiguration> snapshotCopyConfigurations() {
        return snapshotCopyConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotCopyConfigurations() ? snapshotCopyConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSnapshotCopyConfigurationsResponse)) {
            return false;
        }
        ListSnapshotCopyConfigurationsResponse other = (ListSnapshotCopyConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasSnapshotCopyConfigurations() == other.hasSnapshotCopyConfigurations()
                && Objects.equals(snapshotCopyConfigurations(), other.snapshotCopyConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSnapshotCopyConfigurationsResponse").add("NextToken", nextToken())
                .add("SnapshotCopyConfigurations", hasSnapshotCopyConfigurations() ? snapshotCopyConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "snapshotCopyConfigurations":
            return Optional.ofNullable(clazz.cast(snapshotCopyConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("snapshotCopyConfigurations", SNAPSHOT_COPY_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSnapshotCopyConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSnapshotCopyConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSnapshotCopyConfigurationsResponse> {
        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * All of the returned snapshot copy configurations.
         * </p>
         * 
         * @param snapshotCopyConfigurations
         *        All of the returned snapshot copy configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyConfigurations(Collection<SnapshotCopyConfiguration> snapshotCopyConfigurations);

        /**
         * <p>
         * All of the returned snapshot copy configurations.
         * </p>
         * 
         * @param snapshotCopyConfigurations
         *        All of the returned snapshot copy configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyConfigurations(SnapshotCopyConfiguration... snapshotCopyConfigurations);

        /**
         * <p>
         * All of the returned snapshot copy configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #snapshotCopyConfigurations(List<SnapshotCopyConfiguration>)}.
         * 
         * @param snapshotCopyConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.SnapshotCopyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotCopyConfigurations(java.util.Collection<SnapshotCopyConfiguration>)
         */
        Builder snapshotCopyConfigurations(Consumer<SnapshotCopyConfiguration.Builder>... snapshotCopyConfigurations);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SnapshotCopyConfiguration> snapshotCopyConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSnapshotCopyConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            snapshotCopyConfigurations(model.snapshotCopyConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SnapshotCopyConfiguration.Builder> getSnapshotCopyConfigurations() {
            List<SnapshotCopyConfiguration.Builder> result = SnapshotCopyConfigurationsCopier
                    .copyToBuilder(this.snapshotCopyConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotCopyConfigurations(
                Collection<SnapshotCopyConfiguration.BuilderImpl> snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = SnapshotCopyConfigurationsCopier.copyFromBuilder(snapshotCopyConfigurations);
        }

        @Override
        public final Builder snapshotCopyConfigurations(Collection<SnapshotCopyConfiguration> snapshotCopyConfigurations) {
            this.snapshotCopyConfigurations = SnapshotCopyConfigurationsCopier.copy(snapshotCopyConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyConfigurations(SnapshotCopyConfiguration... snapshotCopyConfigurations) {
            snapshotCopyConfigurations(Arrays.asList(snapshotCopyConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyConfigurations(Consumer<SnapshotCopyConfiguration.Builder>... snapshotCopyConfigurations) {
            snapshotCopyConfigurations(Stream.of(snapshotCopyConfigurations)
                    .map(c -> SnapshotCopyConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSnapshotCopyConfigurationsResponse build() {
            return new ListSnapshotCopyConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
