/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationOfferingResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<GetReservationOfferingResponse.Builder, GetReservationOfferingResponse> {
    private static final SdkField<ReservationOffering> RESERVATION_OFFERING_FIELD = SdkField
            .<ReservationOffering> builder(MarshallingType.SDK_POJO).memberName("reservationOffering")
            .getter(getter(GetReservationOfferingResponse::reservationOffering)).setter(setter(Builder::reservationOffering))
            .constructor(ReservationOffering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationOffering").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVATION_OFFERING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ReservationOffering reservationOffering;

    private GetReservationOfferingResponse(BuilderImpl builder) {
        super(builder);
        this.reservationOffering = builder.reservationOffering;
    }

    /**
     * <p>
     * The returned reservation offering. The offering determines the payment schedule for the reservation.
     * </p>
     * 
     * @return The returned reservation offering. The offering determines the payment schedule for the reservation.
     */
    public final ReservationOffering reservationOffering() {
        return reservationOffering;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservationOffering());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationOfferingResponse)) {
            return false;
        }
        GetReservationOfferingResponse other = (GetReservationOfferingResponse) obj;
        return Objects.equals(reservationOffering(), other.reservationOffering());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservationOfferingResponse").add("ReservationOffering", reservationOffering()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reservationOffering":
            return Optional.ofNullable(clazz.cast(reservationOffering()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reservationOffering", RESERVATION_OFFERING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReservationOfferingResponse, T> g) {
        return obj -> g.apply((GetReservationOfferingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationOfferingResponse> {
        /**
         * <p>
         * The returned reservation offering. The offering determines the payment schedule for the reservation.
         * </p>
         * 
         * @param reservationOffering
         *        The returned reservation offering. The offering determines the payment schedule for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationOffering(ReservationOffering reservationOffering);

        /**
         * <p>
         * The returned reservation offering. The offering determines the payment schedule for the reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationOffering.Builder} avoiding the
         * need to create one manually via {@link ReservationOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationOffering.Builder#build()} is called immediately and
         * its result is passed to {@link #reservationOffering(ReservationOffering)}.
         * 
         * @param reservationOffering
         *        a consumer that will call methods on {@link ReservationOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationOffering(ReservationOffering)
         */
        default Builder reservationOffering(Consumer<ReservationOffering.Builder> reservationOffering) {
            return reservationOffering(ReservationOffering.builder().applyMutation(reservationOffering).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private ReservationOffering reservationOffering;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationOfferingResponse model) {
            super(model);
            reservationOffering(model.reservationOffering);
        }

        public final ReservationOffering.Builder getReservationOffering() {
            return reservationOffering != null ? reservationOffering.toBuilder() : null;
        }

        public final void setReservationOffering(ReservationOffering.BuilderImpl reservationOffering) {
            this.reservationOffering = reservationOffering != null ? reservationOffering.build() : null;
        }

        @Override
        public final Builder reservationOffering(ReservationOffering reservationOffering) {
            this.reservationOffering = reservationOffering;
            return this;
        }

        @Override
        public GetReservationOfferingResponse build() {
            return new GetReservationOfferingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
