/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityCenterAuthTokenResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<GetIdentityCenterAuthTokenResponse.Builder, GetIdentityCenterAuthTokenResponse> {
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expirationTime")
            .getter(getter(GetIdentityCenterAuthTokenResponse::expirationTime))
            .setter(setter(Builder::expirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("token")
            .getter(getter(GetIdentityCenterAuthTokenResponse::token)).setter(setter(Builder::token))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_TIME_FIELD,
            TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant expirationTime;

    private final String token;

    private GetIdentityCenterAuthTokenResponse(BuilderImpl builder) {
        super(builder);
        this.expirationTime = builder.expirationTime;
        this.token = builder.token;
    }

    /**
     * <p>
     * The date and time when the Identity Center authentication token expires.
     * </p>
     * <p>
     * After this time, a new token must be requested for continued access.
     * </p>
     * 
     * @return The date and time when the Identity Center authentication token expires.</p>
     *         <p>
     *         After this time, a new token must be requested for continued access.
     */
    public final Instant expirationTime() {
        return expirationTime;
    }

    /**
     * <p>
     * The Identity Center authentication token that can be used to access data in the specified workgroups.
     * </p>
     * <p>
     * This token contains the Identity Center identity information and is encrypted for secure transmission.
     * </p>
     * 
     * @return The Identity Center authentication token that can be used to access data in the specified workgroups.</p>
     *         <p>
     *         This token contains the Identity Center identity information and is encrypted for secure transmission.
     */
    public final String token() {
        return token;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(token());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityCenterAuthTokenResponse)) {
            return false;
        }
        GetIdentityCenterAuthTokenResponse other = (GetIdentityCenterAuthTokenResponse) obj;
        return Objects.equals(expirationTime(), other.expirationTime()) && Objects.equals(token(), other.token());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityCenterAuthTokenResponse").add("ExpirationTime", expirationTime())
                .add("Token", token()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expirationTime":
            return Optional.ofNullable(clazz.cast(expirationTime()));
        case "token":
            return Optional.ofNullable(clazz.cast(token()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("token", TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityCenterAuthTokenResponse, T> g) {
        return obj -> g.apply((GetIdentityCenterAuthTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityCenterAuthTokenResponse> {
        /**
         * <p>
         * The date and time when the Identity Center authentication token expires.
         * </p>
         * <p>
         * After this time, a new token must be requested for continued access.
         * </p>
         * 
         * @param expirationTime
         *        The date and time when the Identity Center authentication token expires.</p>
         *        <p>
         *        After this time, a new token must be requested for continued access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationTime(Instant expirationTime);

        /**
         * <p>
         * The Identity Center authentication token that can be used to access data in the specified workgroups.
         * </p>
         * <p>
         * This token contains the Identity Center identity information and is encrypted for secure transmission.
         * </p>
         * 
         * @param token
         *        The Identity Center authentication token that can be used to access data in the specified
         *        workgroups.</p>
         *        <p>
         *        This token contains the Identity Center identity information and is encrypted for secure transmission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private Instant expirationTime;

        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityCenterAuthTokenResponse model) {
            super(model);
            expirationTime(model.expirationTime);
            token(model.token);
        }

        public final Instant getExpirationTime() {
            return expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getToken() {
            return token;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        @Override
        public GetIdentityCenterAuthTokenResponse build() {
            return new GetIdentityCenterAuthTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
