/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomDomainAssociationsRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<ListCustomDomainAssociationsRequest.Builder, ListCustomDomainAssociationsRequest> {
    private static final SdkField<String> CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("customDomainCertificateArn")
            .getter(getter(ListCustomDomainAssociationsRequest::customDomainCertificateArn))
            .setter(setter(Builder::customDomainCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainCertificateArn").build())
            .build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(ListCustomDomainAssociationsRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListCustomDomainAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomDomainAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD, CUSTOM_DOMAIN_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String customDomainCertificateArn;

    private final String customDomainName;

    private final Integer maxResults;

    private final String nextToken;

    private ListCustomDomainAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.customDomainCertificateArn = builder.customDomainCertificateArn;
        this.customDomainName = builder.customDomainName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The custom domain name’s certificate Amazon resource name (ARN).
     * </p>
     * 
     * @return The custom domain name’s certificate Amazon resource name (ARN).
     */
    public final String customDomainCertificateArn() {
        return customDomainCertificateArn;
    }

    /**
     * <p>
     * The custom domain name associated with the workgroup.
     * </p>
     * 
     * @return The custom domain name associated with the workgroup.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code>
     * to display the next page of results.
     * </p>
     * 
     * @return An optional parameter that specifies the maximum number of results to return. You can use
     *         <code>nextToken</code> to display the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(customDomainCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomDomainAssociationsRequest)) {
            return false;
        }
        ListCustomDomainAssociationsRequest other = (ListCustomDomainAssociationsRequest) obj;
        return Objects.equals(customDomainCertificateArn(), other.customDomainCertificateArn())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomDomainAssociationsRequest")
                .add("CustomDomainCertificateArn", customDomainCertificateArn()).add("CustomDomainName", customDomainName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customDomainCertificateArn":
            return Optional.ofNullable(clazz.cast(customDomainCertificateArn()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customDomainCertificateArn", CUSTOM_DOMAIN_CERTIFICATE_ARN_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomDomainAssociationsRequest, T> g) {
        return obj -> g.apply((ListCustomDomainAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomDomainAssociationsRequest> {
        /**
         * <p>
         * The custom domain name’s certificate Amazon resource name (ARN).
         * </p>
         * 
         * @param customDomainCertificateArn
         *        The custom domain name’s certificate Amazon resource name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainCertificateArn(String customDomainCertificateArn);

        /**
         * <p>
         * The custom domain name associated with the workgroup.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name associated with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * An optional parameter that specifies the maximum number of results to return. You can use
         * <code>nextToken</code> to display the next page of results.
         * </p>
         * 
         * @param maxResults
         *        An optional parameter that specifies the maximum number of results to return. You can use
         *        <code>nextToken</code> to display the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String customDomainCertificateArn;

        private String customDomainName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomDomainAssociationsRequest model) {
            super(model);
            customDomainCertificateArn(model.customDomainCertificateArn);
            customDomainName(model.customDomainName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCustomDomainCertificateArn() {
            return customDomainCertificateArn;
        }

        public final void setCustomDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
        }

        @Override
        public final Builder customDomainCertificateArn(String customDomainCertificateArn) {
            this.customDomainCertificateArn = customDomainCertificateArn;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomDomainAssociationsRequest build() {
            return new ListCustomDomainAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
