/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryPoint> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(RecoveryPoint.getter(RecoveryPoint::namespaceArn)).setter(RecoveryPoint.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(RecoveryPoint.getter(RecoveryPoint::namespaceName)).setter(RecoveryPoint.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final SdkField<Instant> RECOVERY_POINT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("recoveryPointCreateTime").getter(RecoveryPoint.getter(RecoveryPoint::recoveryPointCreateTime)).setter(RecoveryPoint.setter(Builder::recoveryPointCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointCreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryPointId").getter(RecoveryPoint.getter(RecoveryPoint::recoveryPointId)).setter(RecoveryPoint.setter(Builder::recoveryPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()}).build();
    private static final SdkField<Double> TOTAL_SIZE_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("totalSizeInMegaBytes").getter(RecoveryPoint.getter(RecoveryPoint::totalSizeInMegaBytes)).setter(RecoveryPoint.setter(Builder::totalSizeInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSizeInMegaBytes").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(RecoveryPoint.getter(RecoveryPoint::workgroupName)).setter(RecoveryPoint.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, RECOVERY_POINT_CREATE_TIME_FIELD, RECOVERY_POINT_ID_FIELD, TOTAL_SIZE_IN_MEGA_BYTES_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecoveryPoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String namespaceArn;
    private final String namespaceName;
    private final Instant recoveryPointCreateTime;
    private final String recoveryPointId;
    private final Double totalSizeInMegaBytes;
    private final String workgroupName;

    private RecoveryPoint(BuilderImpl builder) {
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.recoveryPointCreateTime = builder.recoveryPointCreateTime;
        this.recoveryPointId = builder.recoveryPointId;
        this.totalSizeInMegaBytes = builder.totalSizeInMegaBytes;
        this.workgroupName = builder.workgroupName;
    }

    public final String namespaceArn() {
        return this.namespaceArn;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final Instant recoveryPointCreateTime() {
        return this.recoveryPointCreateTime;
    }

    public final String recoveryPointId() {
        return this.recoveryPointId;
    }

    public final Double totalSizeInMegaBytes() {
        return this.totalSizeInMegaBytes;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPoint)) {
            return false;
        }
        RecoveryPoint other = (RecoveryPoint)obj;
        return Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.recoveryPointCreateTime(), other.recoveryPointCreateTime()) && Objects.equals(this.recoveryPointId(), other.recoveryPointId()) && Objects.equals(this.totalSizeInMegaBytes(), other.totalSizeInMegaBytes()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryPoint").add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).add("RecoveryPointCreateTime", (Object)this.recoveryPointCreateTime()).add("RecoveryPointId", (Object)this.recoveryPointId()).add("TotalSizeInMegaBytes", (Object)this.totalSizeInMegaBytes()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "recoveryPointCreateTime": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointCreateTime()));
            }
            case "recoveryPointId": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointId()));
            }
            case "totalSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalSizeInMegaBytes()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("recoveryPointCreateTime", RECOVERY_POINT_CREATE_TIME_FIELD);
        map.put("recoveryPointId", RECOVERY_POINT_ID_FIELD);
        map.put("totalSizeInMegaBytes", TOTAL_SIZE_IN_MEGA_BYTES_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPoint, T> g) {
        return obj -> g.apply((RecoveryPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespaceArn;
        private String namespaceName;
        private Instant recoveryPointCreateTime;
        private String recoveryPointId;
        private Double totalSizeInMegaBytes;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPoint model) {
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
            this.recoveryPointCreateTime(model.recoveryPointCreateTime);
            this.recoveryPointId(model.recoveryPointId);
            this.totalSizeInMegaBytes(model.totalSizeInMegaBytes);
            this.workgroupName(model.workgroupName);
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Instant getRecoveryPointCreateTime() {
            return this.recoveryPointCreateTime;
        }

        public final void setRecoveryPointCreateTime(Instant recoveryPointCreateTime) {
            this.recoveryPointCreateTime = recoveryPointCreateTime;
        }

        @Override
        public final Builder recoveryPointCreateTime(Instant recoveryPointCreateTime) {
            this.recoveryPointCreateTime = recoveryPointCreateTime;
            return this;
        }

        public final String getRecoveryPointId() {
            return this.recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final Double getTotalSizeInMegaBytes() {
            return this.totalSizeInMegaBytes;
        }

        public final void setTotalSizeInMegaBytes(Double totalSizeInMegaBytes) {
            this.totalSizeInMegaBytes = totalSizeInMegaBytes;
        }

        @Override
        public final Builder totalSizeInMegaBytes(Double totalSizeInMegaBytes) {
            this.totalSizeInMegaBytes = totalSizeInMegaBytes;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public RecoveryPoint build() {
            return new RecoveryPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryPoint> {
        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);

        public Builder recoveryPointCreateTime(Instant var1);

        public Builder recoveryPointId(String var1);

        public Builder totalSizeInMegaBytes(Double var1);

        public Builder workgroupName(String var1);
    }
}

