/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftserverless.RedshiftServerlessAsyncClient;
import software.amazon.awssdk.services.redshiftserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsRequest;
import software.amazon.awssdk.services.redshiftserverless.model.ListReservationOfferingsResponse;
import software.amazon.awssdk.services.redshiftserverless.model.ReservationOffering;

public class ListReservationOfferingsPublisher
implements SdkPublisher<ListReservationOfferingsResponse> {
    private final RedshiftServerlessAsyncClient client;
    private final ListReservationOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReservationOfferingsPublisher(RedshiftServerlessAsyncClient client, ListReservationOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReservationOfferingsPublisher(RedshiftServerlessAsyncClient client, ListReservationOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReservationOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReservationOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservationOffering> reservationOfferingsList() {
        Function<ListReservationOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservationOfferingsList() != null) {
                return response.reservationOfferingsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReservationOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReservationOfferingsResponseFetcher
    implements AsyncPageFetcher<ListReservationOfferingsResponse> {
        private ListReservationOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(ListReservationOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReservationOfferingsResponse> nextPage(ListReservationOfferingsResponse previousPage) {
            if (previousPage == null) {
                return ListReservationOfferingsPublisher.this.client.listReservationOfferings(ListReservationOfferingsPublisher.this.firstRequest);
            }
            return ListReservationOfferingsPublisher.this.client.listReservationOfferings((ListReservationOfferingsRequest)((Object)ListReservationOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

