/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter;
import software.amazon.awssdk.services.redshiftserverless.model.ConfigParameterListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.PerformanceTarget;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkgroupRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, UpdateWorkgroupRequest> {
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("baseCapacity").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::baseCapacity)).setter(UpdateWorkgroupRequest.setter(Builder::baseCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()}).build();
    private static final SdkField<List<ConfigParameter>> CONFIG_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configParameters").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::configParameters)).setter(UpdateWorkgroupRequest.setter(Builder::configParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedVpcRouting").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::enhancedVpcRouting)).setter(UpdateWorkgroupRequest.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedVpcRouting").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::ipAddressType)).setter(UpdateWorkgroupRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCapacity").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::maxCapacity)).setter(UpdateWorkgroupRequest.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::port)).setter(UpdateWorkgroupRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<PerformanceTarget> PRICE_PERFORMANCE_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pricePerformanceTarget").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::pricePerformanceTarget)).setter(UpdateWorkgroupRequest.setter(Builder::pricePerformanceTarget)).constructor(PerformanceTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricePerformanceTarget").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::publiclyAccessible)).setter(UpdateWorkgroupRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::securityGroupIds)).setter(UpdateWorkgroupRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::subnetIds)).setter(UpdateWorkgroupRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trackName").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::trackName)).setter(UpdateWorkgroupRequest.setter(Builder::trackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackName").build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(UpdateWorkgroupRequest.getter(UpdateWorkgroupRequest::workgroupName)).setter(UpdateWorkgroupRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CAPACITY_FIELD, CONFIG_PARAMETERS_FIELD, ENHANCED_VPC_ROUTING_FIELD, IP_ADDRESS_TYPE_FIELD, MAX_CAPACITY_FIELD, PORT_FIELD, PRICE_PERFORMANCE_TARGET_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, TRACK_NAME_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateWorkgroupRequest.memberNameToFieldInitializer();
    private final Integer baseCapacity;
    private final List<ConfigParameter> configParameters;
    private final Boolean enhancedVpcRouting;
    private final String ipAddressType;
    private final Integer maxCapacity;
    private final Integer port;
    private final PerformanceTarget pricePerformanceTarget;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroupIds;
    private final List<String> subnetIds;
    private final String trackName;
    private final String workgroupName;

    private UpdateWorkgroupRequest(BuilderImpl builder) {
        super(builder);
        this.baseCapacity = builder.baseCapacity;
        this.configParameters = builder.configParameters;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.ipAddressType = builder.ipAddressType;
        this.maxCapacity = builder.maxCapacity;
        this.port = builder.port;
        this.pricePerformanceTarget = builder.pricePerformanceTarget;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.trackName = builder.trackName;
        this.workgroupName = builder.workgroupName;
    }

    public final Integer baseCapacity() {
        return this.baseCapacity;
    }

    public final boolean hasConfigParameters() {
        return this.configParameters != null && !(this.configParameters instanceof SdkAutoConstructList);
    }

    public final List<ConfigParameter> configParameters() {
        return this.configParameters;
    }

    public final Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public final String ipAddressType() {
        return this.ipAddressType;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer port() {
        return this.port;
    }

    public final PerformanceTarget pricePerformanceTarget() {
        return this.pricePerformanceTarget;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String trackName() {
        return this.trackName;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigParameters() ? this.configParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressType());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricePerformanceTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkgroupRequest)) {
            return false;
        }
        UpdateWorkgroupRequest other = (UpdateWorkgroupRequest)((Object)obj);
        return Objects.equals(this.baseCapacity(), other.baseCapacity()) && this.hasConfigParameters() == other.hasConfigParameters() && Objects.equals(this.configParameters(), other.configParameters()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.ipAddressType(), other.ipAddressType()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.pricePerformanceTarget(), other.pricePerformanceTarget()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.trackName(), other.trackName()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkgroupRequest").add("BaseCapacity", (Object)this.baseCapacity()).add("ConfigParameters", this.hasConfigParameters() ? this.configParameters() : null).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("IpAddressType", (Object)this.ipAddressType()).add("MaxCapacity", (Object)this.maxCapacity()).add("Port", (Object)this.port()).add("PricePerformanceTarget", (Object)this.pricePerformanceTarget()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("TrackName", (Object)this.trackName()).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baseCapacity": {
                return Optional.ofNullable(clazz.cast(this.baseCapacity()));
            }
            case "configParameters": {
                return Optional.ofNullable(clazz.cast(this.configParameters()));
            }
            case "enhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressType()));
            }
            case "maxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "pricePerformanceTarget": {
                return Optional.ofNullable(clazz.cast(this.pricePerformanceTarget()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "trackName": {
                return Optional.ofNullable(clazz.cast(this.trackName()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baseCapacity", BASE_CAPACITY_FIELD);
        map.put("configParameters", CONFIG_PARAMETERS_FIELD);
        map.put("enhancedVpcRouting", ENHANCED_VPC_ROUTING_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("maxCapacity", MAX_CAPACITY_FIELD);
        map.put("port", PORT_FIELD);
        map.put("pricePerformanceTarget", PRICE_PERFORMANCE_TARGET_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("trackName", TRACK_NAME_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkgroupRequest, T> g) {
        return obj -> g.apply((UpdateWorkgroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private Integer baseCapacity;
        private List<ConfigParameter> configParameters = DefaultSdkAutoConstructList.getInstance();
        private Boolean enhancedVpcRouting;
        private String ipAddressType;
        private Integer maxCapacity;
        private Integer port;
        private PerformanceTarget pricePerformanceTarget;
        private Boolean publiclyAccessible;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String trackName;
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkgroupRequest model) {
            super(model);
            this.baseCapacity(model.baseCapacity);
            this.configParameters(model.configParameters);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.ipAddressType(model.ipAddressType);
            this.maxCapacity(model.maxCapacity);
            this.port(model.port);
            this.pricePerformanceTarget(model.pricePerformanceTarget);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroupIds(model.securityGroupIds);
            this.subnetIds(model.subnetIds);
            this.trackName(model.trackName);
            this.workgroupName(model.workgroupName);
        }

        public final Integer getBaseCapacity() {
            return this.baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final List<ConfigParameter.Builder> getConfigParameters() {
            List<ConfigParameter.Builder> result = ConfigParameterListCopier.copyToBuilder(this.configParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigParameters(Collection<ConfigParameter.BuilderImpl> configParameters) {
            this.configParameters = ConfigParameterListCopier.copyFromBuilder(configParameters);
        }

        @Override
        public final Builder configParameters(Collection<ConfigParameter> configParameters) {
            this.configParameters = ConfigParameterListCopier.copy(configParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(ConfigParameter ... configParameters) {
            this.configParameters(Arrays.asList(configParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(Consumer<ConfigParameter.Builder> ... configParameters) {
            this.configParameters(Stream.of(configParameters).map(c -> (ConfigParameter)((ConfigParameter.Builder)ConfigParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final PerformanceTarget.Builder getPricePerformanceTarget() {
            return this.pricePerformanceTarget != null ? this.pricePerformanceTarget.toBuilder() : null;
        }

        public final void setPricePerformanceTarget(PerformanceTarget.BuilderImpl pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget != null ? pricePerformanceTarget.build() : null;
        }

        @Override
        public final Builder pricePerformanceTarget(PerformanceTarget pricePerformanceTarget) {
            this.pricePerformanceTarget = pricePerformanceTarget;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getTrackName() {
            return this.trackName;
        }

        public final void setTrackName(String trackName) {
            this.trackName = trackName;
        }

        @Override
        public final Builder trackName(String trackName) {
            this.trackName = trackName;
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkgroupRequest build() {
            return new UpdateWorkgroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkgroupRequest> {
        public Builder baseCapacity(Integer var1);

        public Builder configParameters(Collection<ConfigParameter> var1);

        public Builder configParameters(ConfigParameter ... var1);

        public Builder configParameters(Consumer<ConfigParameter.Builder> ... var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder ipAddressType(String var1);

        public Builder maxCapacity(Integer var1);

        public Builder port(Integer var1);

        public Builder pricePerformanceTarget(PerformanceTarget var1);

        default public Builder pricePerformanceTarget(Consumer<PerformanceTarget.Builder> pricePerformanceTarget) {
            return this.pricePerformanceTarget((PerformanceTarget)((PerformanceTarget.Builder)PerformanceTarget.builder().applyMutation(pricePerformanceTarget)).build());
        }

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder trackName(String var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

