/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.PerformanceTargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PerformanceTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PerformanceTarget> {
    private static final SdkField<Integer> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("level").getter(PerformanceTarget.getter(PerformanceTarget::level)).setter(PerformanceTarget.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PerformanceTarget.getter(PerformanceTarget::statusAsString)).setter(PerformanceTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer level;
    private final String status;

    private PerformanceTarget(BuilderImpl builder) {
        this.level = builder.level;
        this.status = builder.status;
    }

    public final Integer level() {
        return this.level;
    }

    public final PerformanceTargetStatus status() {
        return PerformanceTargetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceTarget)) {
            return false;
        }
        PerformanceTarget other = (PerformanceTarget)obj;
        return Objects.equals(this.level(), other.level()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PerformanceTarget").add("Level", (Object)this.level()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "level": {
                return Optional.ofNullable(clazz.cast(this.level()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PerformanceTarget, T> g) {
        return obj -> g.apply((PerformanceTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer level;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PerformanceTarget model) {
            this.level(model.level);
            this.status(model.status);
        }

        public final Integer getLevel() {
            return this.level;
        }

        public final void setLevel(Integer level) {
            this.level = level;
        }

        @Override
        public final Builder level(Integer level) {
            this.level = level;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PerformanceTargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public PerformanceTarget build() {
            return new PerformanceTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PerformanceTarget> {
        public Builder level(Integer var1);

        public Builder status(String var1);

        public Builder status(PerformanceTargetStatus var1);
    }
}

