/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.ManagedWorkgroupStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ManagedWorkgroupListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ManagedWorkgroupListItem> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(ManagedWorkgroupListItem.getter(ManagedWorkgroupListItem::creationDate)).setter(ManagedWorkgroupListItem.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MANAGED_WORKGROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedWorkgroupId").getter(ManagedWorkgroupListItem.getter(ManagedWorkgroupListItem::managedWorkgroupId)).setter(ManagedWorkgroupListItem.setter(Builder::managedWorkgroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWorkgroupId").build()}).build();
    private static final SdkField<String> MANAGED_WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("managedWorkgroupName").getter(ManagedWorkgroupListItem.getter(ManagedWorkgroupListItem::managedWorkgroupName)).setter(ManagedWorkgroupListItem.setter(Builder::managedWorkgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWorkgroupName").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceArn").getter(ManagedWorkgroupListItem.getter(ManagedWorkgroupListItem::sourceArn)).setter(ManagedWorkgroupListItem.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ManagedWorkgroupListItem.getter(ManagedWorkgroupListItem::statusAsString)).setter(ManagedWorkgroupListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, MANAGED_WORKGROUP_ID_FIELD, MANAGED_WORKGROUP_NAME_FIELD, SOURCE_ARN_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ManagedWorkgroupListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final String managedWorkgroupId;
    private final String managedWorkgroupName;
    private final String sourceArn;
    private final String status;

    private ManagedWorkgroupListItem(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.managedWorkgroupId = builder.managedWorkgroupId;
        this.managedWorkgroupName = builder.managedWorkgroupName;
        this.sourceArn = builder.sourceArn;
        this.status = builder.status;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String managedWorkgroupId() {
        return this.managedWorkgroupId;
    }

    public final String managedWorkgroupName() {
        return this.managedWorkgroupName;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final ManagedWorkgroupStatus status() {
        return ManagedWorkgroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedWorkgroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedWorkgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedWorkgroupListItem)) {
            return false;
        }
        ManagedWorkgroupListItem other = (ManagedWorkgroupListItem)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.managedWorkgroupId(), other.managedWorkgroupId()) && Objects.equals(this.managedWorkgroupName(), other.managedWorkgroupName()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ManagedWorkgroupListItem").add("CreationDate", (Object)this.creationDate()).add("ManagedWorkgroupId", (Object)this.managedWorkgroupId()).add("ManagedWorkgroupName", (Object)this.managedWorkgroupName()).add("SourceArn", (Object)this.sourceArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "managedWorkgroupId": {
                return Optional.ofNullable(clazz.cast(this.managedWorkgroupId()));
            }
            case "managedWorkgroupName": {
                return Optional.ofNullable(clazz.cast(this.managedWorkgroupName()));
            }
            case "sourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("managedWorkgroupId", MANAGED_WORKGROUP_ID_FIELD);
        map.put("managedWorkgroupName", MANAGED_WORKGROUP_NAME_FIELD);
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedWorkgroupListItem, T> g) {
        return obj -> g.apply((ManagedWorkgroupListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private String managedWorkgroupId;
        private String managedWorkgroupName;
        private String sourceArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedWorkgroupListItem model) {
            this.creationDate(model.creationDate);
            this.managedWorkgroupId(model.managedWorkgroupId);
            this.managedWorkgroupName(model.managedWorkgroupName);
            this.sourceArn(model.sourceArn);
            this.status(model.status);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getManagedWorkgroupId() {
            return this.managedWorkgroupId;
        }

        public final void setManagedWorkgroupId(String managedWorkgroupId) {
            this.managedWorkgroupId = managedWorkgroupId;
        }

        @Override
        public final Builder managedWorkgroupId(String managedWorkgroupId) {
            this.managedWorkgroupId = managedWorkgroupId;
            return this;
        }

        public final String getManagedWorkgroupName() {
            return this.managedWorkgroupName;
        }

        public final void setManagedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
        }

        @Override
        public final Builder managedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedWorkgroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ManagedWorkgroupListItem build() {
            return new ManagedWorkgroupListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ManagedWorkgroupListItem> {
        public Builder creationDate(Instant var1);

        public Builder managedWorkgroupId(String var1);

        public Builder managedWorkgroupName(String var1);

        public Builder sourceArn(String var1);

        public Builder status(String var1);

        public Builder status(ManagedWorkgroupStatus var1);
    }
}

