/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.SubnetIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.VpcEndpoint;
import software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointAccess> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("address").getter(EndpointAccess.getter(EndpointAccess::address)).setter(EndpointAccess.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointArn").getter(EndpointAccess.getter(EndpointAccess::endpointArn)).setter(EndpointAccess.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointArn").build()}).build();
    private static final SdkField<Instant> ENDPOINT_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endpointCreateTime").getter(EndpointAccess.getter(EndpointAccess::endpointCreateTime)).setter(EndpointAccess.setter(Builder::endpointCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointCreateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(EndpointAccess.getter(EndpointAccess::endpointName)).setter(EndpointAccess.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointStatus").getter(EndpointAccess.getter(EndpointAccess::endpointStatus)).setter(EndpointAccess.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointStatus").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(EndpointAccess.getter(EndpointAccess::port)).setter(EndpointAccess.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(EndpointAccess.getter(EndpointAccess::subnetIds)).setter(EndpointAccess.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcEndpoint> VPC_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcEndpoint").getter(EndpointAccess.getter(EndpointAccess::vpcEndpoint)).setter(EndpointAccess.setter(Builder::vpcEndpoint)).constructor(VpcEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpoint").build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroups").getter(EndpointAccess.getter(EndpointAccess::vpcSecurityGroups)).setter(EndpointAccess.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(EndpointAccess.getter(EndpointAccess::workgroupName)).setter(EndpointAccess.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_CREATE_TIME_FIELD, ENDPOINT_NAME_FIELD, ENDPOINT_STATUS_FIELD, PORT_FIELD, SUBNET_IDS_FIELD, VPC_ENDPOINT_FIELD, VPC_SECURITY_GROUPS_FIELD, WORKGROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String address;
    private final String endpointArn;
    private final Instant endpointCreateTime;
    private final String endpointName;
    private final String endpointStatus;
    private final Integer port;
    private final List<String> subnetIds;
    private final VpcEndpoint vpcEndpoint;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String workgroupName;

    private EndpointAccess(BuilderImpl builder) {
        this.address = builder.address;
        this.endpointArn = builder.endpointArn;
        this.endpointCreateTime = builder.endpointCreateTime;
        this.endpointName = builder.endpointName;
        this.endpointStatus = builder.endpointStatus;
        this.port = builder.port;
        this.subnetIds = builder.subnetIds;
        this.vpcEndpoint = builder.vpcEndpoint;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.workgroupName = builder.workgroupName;
    }

    public final String address() {
        return this.address;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final Instant endpointCreateTime() {
        return this.endpointCreateTime;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointStatus() {
        return this.endpointStatus;
    }

    public final Integer port() {
        return this.port;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final VpcEndpoint vpcEndpoint() {
        return this.vpcEndpoint;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAccess)) {
            return false;
        }
        EndpointAccess other = (EndpointAccess)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointCreateTime(), other.endpointCreateTime()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointStatus(), other.endpointStatus()) && Objects.equals(this.port(), other.port()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.vpcEndpoint(), other.vpcEndpoint()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointAccess").add("Address", (Object)this.address()).add("EndpointArn", (Object)this.endpointArn()).add("EndpointCreateTime", (Object)this.endpointCreateTime()).add("EndpointName", (Object)this.endpointName()).add("EndpointStatus", (Object)this.endpointStatus()).add("Port", (Object)this.port()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcEndpoint", (Object)this.vpcEndpoint()).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "endpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "endpointCreateTime": {
                return Optional.ofNullable(clazz.cast(this.endpointCreateTime()));
            }
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "endpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatus()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "vpcEndpoint": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpoint()));
            }
            case "vpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointAccess, T> g) {
        return obj -> g.apply((EndpointAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private String endpointArn;
        private Instant endpointCreateTime;
        private String endpointName;
        private String endpointStatus;
        private Integer port;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private VpcEndpoint vpcEndpoint;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointAccess model) {
            this.address(model.address);
            this.endpointArn(model.endpointArn);
            this.endpointCreateTime(model.endpointCreateTime);
            this.endpointName(model.endpointName);
            this.endpointStatus(model.endpointStatus);
            this.port(model.port);
            this.subnetIds(model.subnetIds);
            this.vpcEndpoint(model.vpcEndpoint);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.workgroupName(model.workgroupName);
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final Instant getEndpointCreateTime() {
            return this.endpointCreateTime;
        }

        public final void setEndpointCreateTime(Instant endpointCreateTime) {
            this.endpointCreateTime = endpointCreateTime;
        }

        @Override
        public final Builder endpointCreateTime(Instant endpointCreateTime) {
            this.endpointCreateTime = endpointCreateTime;
            return this;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return this.vpcEndpoint != null ? this.vpcEndpoint.toBuilder() : null;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        public EndpointAccess build() {
            return new EndpointAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointAccess> {
        public Builder address(String var1);

        public Builder endpointArn(String var1);

        public Builder endpointCreateTime(Instant var1);

        public Builder endpointName(String var1);

        public Builder endpointStatus(String var1);

        public Builder port(Integer var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcEndpoint(VpcEndpoint var1);

        default public Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return this.vpcEndpoint((VpcEndpoint)((VpcEndpoint.Builder)VpcEndpoint.builder().applyMutation(vpcEndpoint)).build());
        }

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder workgroupName(String var1);
    }
}

