/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitBreachAction;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitPeriod;
import software.amazon.awssdk.services.redshiftserverless.model.UsageLimitUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageLimit> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("amount").getter(UsageLimit.getter(UsageLimit::amount)).setter(UsageLimit.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()}).build();
    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("breachAction").getter(UsageLimit.getter(UsageLimit::breachActionAsString)).setter(UsageLimit.setter(Builder::breachAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(UsageLimit.getter(UsageLimit::periodAsString)).setter(UsageLimit.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(UsageLimit.getter(UsageLimit::resourceArn)).setter(UsageLimit.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> USAGE_LIMIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageLimitArn").getter(UsageLimit.getter(UsageLimit::usageLimitArn)).setter(UsageLimit.setter(Builder::usageLimitArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitArn").build()}).build();
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageLimitId").getter(UsageLimit.getter(UsageLimit::usageLimitId)).setter(UsageLimit.setter(Builder::usageLimitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitId").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(UsageLimit.getter(UsageLimit::usageTypeAsString)).setter(UsageLimit.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, BREACH_ACTION_FIELD, PERIOD_FIELD, RESOURCE_ARN_FIELD, USAGE_LIMIT_ARN_FIELD, USAGE_LIMIT_ID_FIELD, USAGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long amount;
    private final String breachAction;
    private final String period;
    private final String resourceArn;
    private final String usageLimitArn;
    private final String usageLimitId;
    private final String usageType;

    private UsageLimit(BuilderImpl builder) {
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.period = builder.period;
        this.resourceArn = builder.resourceArn;
        this.usageLimitArn = builder.usageLimitArn;
        this.usageLimitId = builder.usageLimitId;
        this.usageType = builder.usageType;
    }

    public final Long amount() {
        return this.amount;
    }

    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(this.breachAction);
    }

    public final String breachActionAsString() {
        return this.breachAction;
    }

    public final UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String usageLimitArn() {
        return this.usageLimitArn;
    }

    public final String usageLimitId() {
        return this.usageLimitId;
    }

    public final UsageLimitUsageType usageType() {
        return UsageLimitUsageType.fromValue(this.usageType);
    }

    public final String usageTypeAsString() {
        return this.usageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageLimitArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageLimit)) {
            return false;
        }
        UsageLimit other = (UsageLimit)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.breachActionAsString(), other.breachActionAsString()) && Objects.equals(this.periodAsString(), other.periodAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.usageLimitArn(), other.usageLimitArn()) && Objects.equals(this.usageLimitId(), other.usageLimitId()) && Objects.equals(this.usageTypeAsString(), other.usageTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UsageLimit").add("Amount", (Object)this.amount()).add("BreachAction", (Object)this.breachActionAsString()).add("Period", (Object)this.periodAsString()).add("ResourceArn", (Object)this.resourceArn()).add("UsageLimitArn", (Object)this.usageLimitArn()).add("UsageLimitId", (Object)this.usageLimitId()).add("UsageType", (Object)this.usageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "breachAction": {
                return Optional.ofNullable(clazz.cast(this.breachActionAsString()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "usageLimitArn": {
                return Optional.ofNullable(clazz.cast(this.usageLimitArn()));
            }
            case "usageLimitId": {
                return Optional.ofNullable(clazz.cast(this.usageLimitId()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageLimit, T> g) {
        return obj -> g.apply((UsageLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long amount;
        private String breachAction;
        private String period;
        private String resourceArn;
        private String usageLimitArn;
        private String usageLimitId;
        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageLimit model) {
            this.amount(model.amount);
            this.breachAction(model.breachAction);
            this.period(model.period);
            this.resourceArn(model.resourceArn);
            this.usageLimitArn(model.usageLimitArn);
            this.usageLimitId(model.usageLimitId);
            this.usageType(model.usageType);
        }

        public final Long getAmount() {
            return this.amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return this.breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getUsageLimitArn() {
            return this.usageLimitArn;
        }

        public final void setUsageLimitArn(String usageLimitArn) {
            this.usageLimitArn = usageLimitArn;
        }

        @Override
        public final Builder usageLimitArn(String usageLimitArn) {
            this.usageLimitArn = usageLimitArn;
            return this;
        }

        public final String getUsageLimitId() {
            return this.usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageLimitUsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        public UsageLimit build() {
            return new UsageLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageLimit> {
        public Builder amount(Long var1);

        public Builder breachAction(String var1);

        public Builder breachAction(UsageLimitBreachAction var1);

        public Builder period(String var1);

        public Builder period(UsageLimitPeriod var1);

        public Builder resourceArn(String var1);

        public Builder usageLimitArn(String var1);

        public Builder usageLimitId(String var1);

        public Builder usageType(String var1);

        public Builder usageType(UsageLimitUsageType var1);
    }
}

