/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStatementResultResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<GetStatementResultResponse.Builder, GetStatementResultResponse> {
    private static final SdkField<List<List<Field>>> RECORDS_FIELD = SdkField
            .<List<List<Field>>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(GetStatementResultResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<Field>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(Field::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("ColumnMetadata")
            .getter(getter(GetStatementResultResponse::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_NUM_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumRows").getter(getter(GetStatementResultResponse::totalNumRows))
            .setter(setter(Builder::totalNumRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumRows").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetStatementResultResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            COLUMN_METADATA_FIELD, TOTAL_NUM_ROWS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<List<Field>> records;

    private final List<ColumnMetadata> columnMetadata;

    private final Long totalNumRows;

    private final String nextToken;

    private GetStatementResultResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.columnMetadata = builder.columnMetadata;
        this.totalNumRows = builder.totalNumRows;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the SQL statement in JSON format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The results of the SQL statement in JSON format.
     */
    public final List<List<Field>> records() {
        return records;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnMetadata() {
        return columnMetadata != null && !(columnMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties (metadata) of a column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnMetadata} method.
     * </p>
     * 
     * @return The properties (metadata) of a column.
     */
    public final List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    /**
     * <p>
     * The total number of rows in the result set returned from a query. You can use this number to estimate the number
     * of calls to the <code>GetStatementResult</code> operation needed to page through the results.
     * </p>
     * 
     * @return The total number of rows in the result set returned from a query. You can use this number to estimate the
     *         number of calls to the <code>GetStatementResult</code> operation needed to page through the results.
     */
    public final Long totalNumRows() {
        return totalNumRows;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnMetadata() ? columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNumRows());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatementResultResponse)) {
            return false;
        }
        GetStatementResultResponse other = (GetStatementResultResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(columnMetadata(), other.columnMetadata())
                && Objects.equals(totalNumRows(), other.totalNumRows()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStatementResultResponse").add("Records", hasRecords() ? records() : null)
                .add("ColumnMetadata", hasColumnMetadata() ? columnMetadata() : null).add("TotalNumRows", totalNumRows())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "ColumnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        case "TotalNumRows":
            return Optional.ofNullable(clazz.cast(totalNumRows()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Records", RECORDS_FIELD);
        map.put("ColumnMetadata", COLUMN_METADATA_FIELD);
        map.put("TotalNumRows", TOTAL_NUM_ROWS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStatementResultResponse, T> g) {
        return obj -> g.apply((GetStatementResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetStatementResultResponse> {
        /**
         * <p>
         * The results of the SQL statement in JSON format.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<? extends Collection<Field>> records);

        /**
         * <p>
         * The results of the SQL statement in JSON format.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Field>... records);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(java.util.Collection<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);

        /**
         * <p>
         * The total number of rows in the result set returned from a query. You can use this number to estimate the
         * number of calls to the <code>GetStatementResult</code> operation needed to page through the results.
         * </p>
         * 
         * @param totalNumRows
         *        The total number of rows in the result set returned from a query. You can use this number to estimate
         *        the number of calls to the <code>GetStatementResult</code> operation needed to page through the
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumRows(Long totalNumRows);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private List<List<Field>> records = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private Long totalNumRows;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatementResultResponse model) {
            super(model);
            records(model.records);
            columnMetadata(model.columnMetadata);
            totalNumRows(model.totalNumRows);
            nextToken(model.nextToken);
        }

        public final List<List<Field.Builder>> getRecords() {
            List<List<Field.Builder>> result = SqlRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<? extends Collection<Field.BuilderImpl>> records) {
            this.records = SqlRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<? extends Collection<Field>> records) {
            this.records = SqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Collection<Field>... records) {
            records(Arrays.asList(records));
            return this;
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = ColumnMetadataListCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTotalNumRows() {
            return totalNumRows;
        }

        public final void setTotalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
        }

        @Override
        public final Builder totalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetStatementResultResponse build() {
            return new GetStatementResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
