/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftdata.model.ColumnListCopier;
import software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableResponse
extends RedshiftDataResponse
implements ToCopyableBuilder<Builder, DescribeTableResponse> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnList").getter(DescribeTableResponse.getter(DescribeTableResponse::columnList)).setter(DescribeTableResponse.setter(Builder::columnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTableResponse.getter(DescribeTableResponse::nextToken)).setter(DescribeTableResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DescribeTableResponse.getter(DescribeTableResponse::tableName)).setter(DescribeTableResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_LIST_FIELD, NEXT_TOKEN_FIELD, TABLE_NAME_FIELD));
    private final List<ColumnMetadata> columnList;
    private final String nextToken;
    private final String tableName;

    private DescribeTableResponse(BuilderImpl builder) {
        super(builder);
        this.columnList = builder.columnList;
        this.nextToken = builder.nextToken;
        this.tableName = builder.tableName;
    }

    public final boolean hasColumnList() {
        return this.columnList != null && !(this.columnList instanceof SdkAutoConstructList);
    }

    public final List<ColumnMetadata> columnList() {
        return this.columnList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String tableName() {
        return this.tableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnList() ? this.columnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableResponse)) {
            return false;
        }
        DescribeTableResponse other = (DescribeTableResponse)((Object)obj);
        return this.hasColumnList() == other.hasColumnList() && Objects.equals(this.columnList(), other.columnList()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.tableName(), other.tableName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTableResponse").add("ColumnList", this.hasColumnList() ? this.columnList() : null).add("NextToken", (Object)this.nextToken()).add("TableName", (Object)this.tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnList": {
                return Optional.ofNullable(clazz.cast(this.columnList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableResponse, T> g) {
        return obj -> g.apply((DescribeTableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataResponse.BuilderImpl
    implements Builder {
        private List<ColumnMetadata> columnList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableResponse model) {
            super(model);
            this.columnList(model.columnList);
            this.nextToken(model.nextToken);
            this.tableName(model.tableName);
        }

        public final List<ColumnMetadata.Builder> getColumnList() {
            List<ColumnMetadata.Builder> result = ColumnListCopier.copyToBuilder(this.columnList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnList(Collection<ColumnMetadata.BuilderImpl> columnList) {
            this.columnList = ColumnListCopier.copyFromBuilder(columnList);
        }

        @Override
        public final Builder columnList(Collection<ColumnMetadata> columnList) {
            this.columnList = ColumnListCopier.copy(columnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnList(ColumnMetadata ... columnList) {
            this.columnList(Arrays.asList(columnList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnList(Consumer<ColumnMetadata.Builder> ... columnList) {
            this.columnList(Stream.of(columnList).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public DescribeTableResponse build() {
            return new DescribeTableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTableResponse> {
        public Builder columnList(Collection<ColumnMetadata> var1);

        public Builder columnList(ColumnMetadata ... var1);

        public Builder columnList(Consumer<ColumnMetadata.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder tableName(String var1);
    }
}

