/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StatusString {
    ABORTED("ABORTED"),
    ALL("ALL"),
    FAILED("FAILED"),
    FINISHED("FINISHED"),
    PICKED("PICKED"),
    STARTED("STARTED"),
    SUBMITTED("SUBMITTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StatusString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StatusString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StatusString.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StatusString> knownValues() {
        return Stream.of(StatusString.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

