/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusResponse;
import software.amazon.awssdk.services.redshift.model.TableRestoreStatus;

public class DescribeTableRestoreStatusPublisher
implements SdkPublisher<DescribeTableRestoreStatusResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeTableRestoreStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTableRestoreStatusPublisher(RedshiftAsyncClient client, DescribeTableRestoreStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTableRestoreStatusPublisher(RedshiftAsyncClient client, DescribeTableRestoreStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTableRestoreStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTableRestoreStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TableRestoreStatus> tableRestoreStatusDetails() {
        return this.flatMapIterable(response -> response.tableRestoreStatusDetails());
    }

    private class DescribeTableRestoreStatusResponseFetcher
    implements AsyncPageFetcher<DescribeTableRestoreStatusResponse> {
        private DescribeTableRestoreStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableRestoreStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeTableRestoreStatusResponse> nextPage(DescribeTableRestoreStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeTableRestoreStatusPublisher.this.client.describeTableRestoreStatus(DescribeTableRestoreStatusPublisher.this.firstRequest);
            }
            return DescribeTableRestoreStatusPublisher.this.client.describeTableRestoreStatus((DescribeTableRestoreStatusRequest)((Object)DescribeTableRestoreStatusPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

