/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotSchedulesResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotSchedule;

public class DescribeSnapshotSchedulesPublisher
implements SdkPublisher<DescribeSnapshotSchedulesResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeSnapshotSchedulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotSchedulesPublisher(RedshiftAsyncClient client, DescribeSnapshotSchedulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotSchedulesPublisher(RedshiftAsyncClient client, DescribeSnapshotSchedulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotSchedulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotSchedulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotSchedule> snapshotSchedules() {
        return this.flatMapIterable(response -> response.snapshotSchedules());
    }

    private class DescribeSnapshotSchedulesResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotSchedulesResponse> {
        private DescribeSnapshotSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeSnapshotSchedulesResponse> nextPage(DescribeSnapshotSchedulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotSchedulesPublisher.this.client.describeSnapshotSchedules(DescribeSnapshotSchedulesPublisher.this.firstRequest);
            }
            return DescribeSnapshotSchedulesPublisher.this.client.describeSnapshotSchedules((DescribeSnapshotSchedulesRequest)((Object)DescribeSnapshotSchedulesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

