/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant;

public class DescribeSnapshotCopyGrantsPublisher
implements SdkPublisher<DescribeSnapshotCopyGrantsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeSnapshotCopyGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotCopyGrantsPublisher(RedshiftAsyncClient client, DescribeSnapshotCopyGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotCopyGrantsPublisher(RedshiftAsyncClient client, DescribeSnapshotCopyGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotCopyGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotCopyGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SnapshotCopyGrant> snapshotCopyGrants() {
        return this.flatMapIterable(response -> response.snapshotCopyGrants());
    }

    private class DescribeSnapshotCopyGrantsResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotCopyGrantsResponse> {
        private DescribeSnapshotCopyGrantsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotCopyGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeSnapshotCopyGrantsResponse> nextPage(DescribeSnapshotCopyGrantsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotCopyGrantsPublisher.this.client.describeSnapshotCopyGrants(DescribeSnapshotCopyGrantsPublisher.this.firstRequest);
            }
            return DescribeSnapshotCopyGrantsPublisher.this.client.describeSnapshotCopyGrants((DescribeSnapshotCopyGrantsRequest)((Object)DescribeSnapshotCopyGrantsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

