/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus;

public class DescribeReservedNodeExchangeStatusPublisher
implements SdkPublisher<DescribeReservedNodeExchangeStatusResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeReservedNodeExchangeStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedNodeExchangeStatusPublisher(RedshiftAsyncClient client, DescribeReservedNodeExchangeStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedNodeExchangeStatusPublisher(RedshiftAsyncClient client, DescribeReservedNodeExchangeStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedNodeExchangeStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedNodeExchangeStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails() {
        return this.flatMapIterable(response -> response.reservedNodeExchangeStatusDetails());
    }

    private class DescribeReservedNodeExchangeStatusResponseFetcher
    implements AsyncPageFetcher<DescribeReservedNodeExchangeStatusResponse> {
        private DescribeReservedNodeExchangeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReservedNodeExchangeStatusResponse> nextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeExchangeStatusPublisher.this.client.describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusPublisher.this.firstRequest);
            }
            return DescribeReservedNodeExchangeStatusPublisher.this.client.describeReservedNodeExchangeStatus((DescribeReservedNodeExchangeStatusRequest)((Object)DescribeReservedNodeExchangeStatusPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

