/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;

public class DescribeOrderableClusterOptionsPublisher
implements SdkPublisher<DescribeOrderableClusterOptionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeOrderableClusterOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrderableClusterOptionsPublisher(RedshiftAsyncClient client, DescribeOrderableClusterOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrderableClusterOptionsPublisher(RedshiftAsyncClient client, DescribeOrderableClusterOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrderableClusterOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrderableClusterOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrderableClusterOption> orderableClusterOptions() {
        return this.flatMapIterable(response -> response.orderableClusterOptions());
    }

    private class DescribeOrderableClusterOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOrderableClusterOptionsResponse> {
        private DescribeOrderableClusterOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOrderableClusterOptionsResponse> nextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableClusterOptionsPublisher.this.client.describeOrderableClusterOptions(DescribeOrderableClusterOptionsPublisher.this.firstRequest);
            }
            return DescribeOrderableClusterOptionsPublisher.this.client.describeOrderableClusterOptions((DescribeOrderableClusterOptionsRequest)((Object)DescribeOrderableClusterOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

