/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;

public class DescribeHsmClientCertificatesIterable
implements SdkIterable<DescribeHsmClientCertificatesResponse> {
    private final RedshiftClient client;
    private final DescribeHsmClientCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHsmClientCertificatesIterable(RedshiftClient client, DescribeHsmClientCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeHsmClientCertificatesResponseFetcher();
    }

    public Iterator<DescribeHsmClientCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HsmClientCertificate> hsmClientCertificates() {
        Function<DescribeHsmClientCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hsmClientCertificates() != null) {
                return response.hsmClientCertificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeHsmClientCertificatesResponseFetcher
    implements SyncPageFetcher<DescribeHsmClientCertificatesResponse> {
        private DescribeHsmClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmClientCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeHsmClientCertificatesResponse nextPage(DescribeHsmClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmClientCertificatesIterable.this.client.describeHsmClientCertificates(DescribeHsmClientCertificatesIterable.this.firstRequest);
            }
            return DescribeHsmClientCertificatesIterable.this.client.describeHsmClientCertificates((DescribeHsmClientCertificatesRequest)((Object)DescribeHsmClientCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

