/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.redshift.model.EventSubscription;

public class DescribeEventSubscriptionsPublisher
implements SdkPublisher<DescribeEventSubscriptionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeEventSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventSubscriptionsPublisher(RedshiftAsyncClient client, DescribeEventSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventSubscriptionsPublisher(RedshiftAsyncClient client, DescribeEventSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventSubscription> eventSubscriptionsList() {
        return this.flatMapIterable(response -> response.eventSubscriptionsList());
    }

    private class DescribeEventSubscriptionsResponseFetcher
    implements AsyncPageFetcher<DescribeEventSubscriptionsResponse> {
        private DescribeEventSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEventSubscriptionsResponse> nextPage(DescribeEventSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventSubscriptionsPublisher.this.client.describeEventSubscriptions(DescribeEventSubscriptionsPublisher.this.firstRequest);
            }
            return DescribeEventSubscriptionsPublisher.this.client.describeEventSubscriptions((DescribeEventSubscriptionsRequest)((Object)DescribeEventSubscriptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

