/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerRequest;
import software.amazon.awssdk.services.redshift.model.DescribeDataSharesForProducerResponse;

public class DescribeDataSharesForProducerPublisher
implements SdkPublisher<DescribeDataSharesForProducerResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeDataSharesForProducerRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDataSharesForProducerPublisher(RedshiftAsyncClient client, DescribeDataSharesForProducerRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDataSharesForProducerPublisher(RedshiftAsyncClient client, DescribeDataSharesForProducerRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDataSharesForProducerResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDataSharesForProducerResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataShare> dataShares() {
        return this.flatMapIterable(response -> response.dataShares());
    }

    private class DescribeDataSharesForProducerResponseFetcher
    implements AsyncPageFetcher<DescribeDataSharesForProducerResponse> {
        private DescribeDataSharesForProducerResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDataSharesForProducerResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDataSharesForProducerResponse> nextPage(DescribeDataSharesForProducerResponse previousPage) {
            if (previousPage == null) {
                return DescribeDataSharesForProducerPublisher.this.client.describeDataSharesForProducer(DescribeDataSharesForProducerPublisher.this.firstRequest);
            }
            return DescribeDataSharesForProducerPublisher.this.client.describeDataSharesForProducer((DescribeDataSharesForProducerRequest)((Object)DescribeDataSharesForProducerPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

