/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;

public class DescribeClustersPublisher
implements SdkPublisher<DescribeClustersResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClustersPublisher(RedshiftAsyncClient client, DescribeClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClustersPublisher(RedshiftAsyncClient client, DescribeClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Cluster> clusters() {
        return this.flatMapIterable(response -> response.clusters());
    }

    private class DescribeClustersResponseFetcher
    implements AsyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClustersResponse> nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPublisher.this.client.describeClusters(DescribeClustersPublisher.this.firstRequest);
            }
            return DescribeClustersPublisher.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

