/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupsCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSubnetGroupsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterSubnetGroupsResponse.getter(DescribeClusterSubnetGroupsResponse::marker)).setter(DescribeClusterSubnetGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ClusterSubnetGroup>> CLUSTER_SUBNET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSubnetGroups").getter(DescribeClusterSubnetGroupsResponse.getter(DescribeClusterSubnetGroupsResponse::clusterSubnetGroups)).setter(DescribeClusterSubnetGroupsResponse.setter(Builder::clusterSubnetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroups").build(), ListTrait.builder().memberLocationName("ClusterSubnetGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTER_SUBNET_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterSubnetGroupsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<ClusterSubnetGroup> clusterSubnetGroups;

    private DescribeClusterSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSubnetGroups = builder.clusterSubnetGroups;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasClusterSubnetGroups() {
        return this.clusterSubnetGroups != null && !(this.clusterSubnetGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterSubnetGroup> clusterSubnetGroups() {
        return this.clusterSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSubnetGroups() ? this.clusterSubnetGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSubnetGroupsResponse)) {
            return false;
        }
        DescribeClusterSubnetGroupsResponse other = (DescribeClusterSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasClusterSubnetGroups() == other.hasClusterSubnetGroups() && Objects.equals(this.clusterSubnetGroups(), other.clusterSubnetGroups());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("ClusterSubnetGroups", this.hasClusterSubnetGroups() ? this.clusterSubnetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ClusterSubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("ClusterSubnetGroups", CLUSTER_SUBNET_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeClusterSubnetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSubnetGroup> clusterSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterSubnetGroups(model.clusterSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterSubnetGroup.Builder> getClusterSubnetGroups() {
            List<ClusterSubnetGroup.Builder> result = ClusterSubnetGroupsCopier.copyToBuilder(this.clusterSubnetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSubnetGroups(Collection<ClusterSubnetGroup.BuilderImpl> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copyFromBuilder(clusterSubnetGroups);
        }

        @Override
        public final Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copy(clusterSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(ClusterSubnetGroup ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Arrays.asList(clusterSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder> ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Stream.of(clusterSubnetGroups).map(c -> (ClusterSubnetGroup)((ClusterSubnetGroup.Builder)ClusterSubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterSubnetGroupsResponse build() {
            return new DescribeClusterSubnetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> var1);

        public Builder clusterSubnetGroups(ClusterSubnetGroup ... var1);

        public Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder> ... var1);
    }
}

