/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsRequest;
import software.amazon.awssdk.services.redshift.model.GetReservedNodeExchangeConfigurationOptionsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeConfigurationOption;

public class GetReservedNodeExchangeConfigurationOptionsPublisher
implements SdkPublisher<GetReservedNodeExchangeConfigurationOptionsResponse> {
    private final RedshiftAsyncClient client;
    private final GetReservedNodeExchangeConfigurationOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetReservedNodeExchangeConfigurationOptionsPublisher(RedshiftAsyncClient client, GetReservedNodeExchangeConfigurationOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetReservedNodeExchangeConfigurationOptionsPublisher(RedshiftAsyncClient client, GetReservedNodeExchangeConfigurationOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetReservedNodeExchangeConfigurationOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetReservedNodeExchangeConfigurationOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedNodeConfigurationOption> reservedNodeConfigurationOptionList() {
        return this.flatMapIterable(response -> response.reservedNodeConfigurationOptionList());
    }

    private class GetReservedNodeExchangeConfigurationOptionsResponseFetcher
    implements AsyncPageFetcher<GetReservedNodeExchangeConfigurationOptionsResponse> {
        private GetReservedNodeExchangeConfigurationOptionsResponseFetcher() {
        }

        public boolean hasNextPage(GetReservedNodeExchangeConfigurationOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<GetReservedNodeExchangeConfigurationOptionsResponse> nextPage(GetReservedNodeExchangeConfigurationOptionsResponse previousPage) {
            if (previousPage == null) {
                return GetReservedNodeExchangeConfigurationOptionsPublisher.this.client.getReservedNodeExchangeConfigurationOptions(GetReservedNodeExchangeConfigurationOptionsPublisher.this.firstRequest);
            }
            return GetReservedNodeExchangeConfigurationOptionsPublisher.this.client.getReservedNodeExchangeConfigurationOptions((GetReservedNodeExchangeConfigurationOptionsRequest)((Object)GetReservedNodeExchangeConfigurationOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

