/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeIntegrationsResponse;
import software.amazon.awssdk.services.redshift.model.Integration;

public class DescribeIntegrationsPublisher
implements SdkPublisher<DescribeIntegrationsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeIntegrationsPublisher(RedshiftAsyncClient client, DescribeIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeIntegrationsPublisher(RedshiftAsyncClient client, DescribeIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Integration> integrations() {
        return this.flatMapIterable(response -> response.integrations());
    }

    private class DescribeIntegrationsResponseFetcher
    implements AsyncPageFetcher<DescribeIntegrationsResponse> {
        private DescribeIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeIntegrationsResponse> nextPage(DescribeIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIntegrationsPublisher.this.client.describeIntegrations(DescribeIntegrationsPublisher.this.firstRequest);
            }
            return DescribeIntegrationsPublisher.this.client.describeIntegrations((DescribeIntegrationsRequest)((Object)DescribeIntegrationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

