/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse;
import software.amazon.awssdk.services.redshift.model.HsmConfiguration;

public class DescribeHsmConfigurationsPublisher
implements SdkPublisher<DescribeHsmConfigurationsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeHsmConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeHsmConfigurationsPublisher(RedshiftAsyncClient client, DescribeHsmConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeHsmConfigurationsPublisher(RedshiftAsyncClient client, DescribeHsmConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeHsmConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeHsmConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HsmConfiguration> hsmConfigurations() {
        return this.flatMapIterable(response -> response.hsmConfigurations());
    }

    private class DescribeHsmConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeHsmConfigurationsResponse> {
        private DescribeHsmConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeHsmConfigurationsResponse> nextPage(DescribeHsmConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmConfigurationsPublisher.this.client.describeHsmConfigurations(DescribeHsmConfigurationsPublisher.this.firstRequest);
            }
            return DescribeHsmConfigurationsPublisher.this.client.describeHsmConfigurations((DescribeHsmConfigurationsRequest)((Object)DescribeHsmConfigurationsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

