/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;

public class DescribeClusterVersionsPublisher
implements SdkPublisher<DescribeClusterVersionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterVersionsPublisher(RedshiftAsyncClient client, DescribeClusterVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterVersionsPublisher(RedshiftAsyncClient client, DescribeClusterVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterVersion> clusterVersions() {
        return this.flatMapIterable(response -> response.clusterVersions());
    }

    private class DescribeClusterVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterVersionsResponse> nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsPublisher.this.client.describeClusterVersions(DescribeClusterVersionsPublisher.this.firstRequest);
            }
            return DescribeClusterVersionsPublisher.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

