/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;

public class DescribeClusterSecurityGroupsPublisher
implements SdkPublisher<DescribeClusterSecurityGroupsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterSecurityGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterSecurityGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterSecurityGroup> clusterSecurityGroups() {
        return this.flatMapIterable(response -> response.clusterSecurityGroups());
    }

    private class DescribeClusterSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterSecurityGroupsResponse> {
        private DescribeClusterSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterSecurityGroupsResponse> nextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSecurityGroupsPublisher.this.client.describeClusterSecurityGroups(DescribeClusterSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeClusterSecurityGroupsPublisher.this.client.describeClusterSecurityGroups((DescribeClusterSecurityGroupsRequest)((Object)DescribeClusterSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

