/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ConsumerIdentifierListCopier;
import software.amazon.awssdk.services.redshift.model.NamespaceIdentifierUnion;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeregisterNamespaceRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeregisterNamespaceRequest> {
    private static final SdkField<NamespaceIdentifierUnion> NAMESPACE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NamespaceIdentifier").getter(DeregisterNamespaceRequest.getter(DeregisterNamespaceRequest::namespaceIdentifier)).setter(DeregisterNamespaceRequest.setter(Builder::namespaceIdentifier)).constructor(NamespaceIdentifierUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceIdentifier").build()}).build();
    private static final SdkField<List<String>> CONSUMER_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumerIdentifiers").getter(DeregisterNamespaceRequest.getter(DeregisterNamespaceRequest::consumerIdentifiers)).setter(DeregisterNamespaceRequest.setter(Builder::consumerIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_IDENTIFIER_FIELD, CONSUMER_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeregisterNamespaceRequest.memberNameToFieldInitializer();
    private final NamespaceIdentifierUnion namespaceIdentifier;
    private final List<String> consumerIdentifiers;

    private DeregisterNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceIdentifier = builder.namespaceIdentifier;
        this.consumerIdentifiers = builder.consumerIdentifiers;
    }

    public final NamespaceIdentifierUnion namespaceIdentifier() {
        return this.namespaceIdentifier;
    }

    public final boolean hasConsumerIdentifiers() {
        return this.consumerIdentifiers != null && !(this.consumerIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> consumerIdentifiers() {
        return this.consumerIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumerIdentifiers() ? this.consumerIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterNamespaceRequest)) {
            return false;
        }
        DeregisterNamespaceRequest other = (DeregisterNamespaceRequest)((Object)obj);
        return Objects.equals(this.namespaceIdentifier(), other.namespaceIdentifier()) && this.hasConsumerIdentifiers() == other.hasConsumerIdentifiers() && Objects.equals(this.consumerIdentifiers(), other.consumerIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"DeregisterNamespaceRequest").add("NamespaceIdentifier", (Object)this.namespaceIdentifier()).add("ConsumerIdentifiers", this.hasConsumerIdentifiers() ? this.consumerIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.namespaceIdentifier()));
            }
            case "ConsumerIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.consumerIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NamespaceIdentifier", NAMESPACE_IDENTIFIER_FIELD);
        map.put("ConsumerIdentifiers", CONSUMER_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterNamespaceRequest, T> g) {
        return obj -> g.apply((DeregisterNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private NamespaceIdentifierUnion namespaceIdentifier;
        private List<String> consumerIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterNamespaceRequest model) {
            super(model);
            this.namespaceIdentifier(model.namespaceIdentifier);
            this.consumerIdentifiers(model.consumerIdentifiers);
        }

        public final NamespaceIdentifierUnion.Builder getNamespaceIdentifier() {
            return this.namespaceIdentifier != null ? this.namespaceIdentifier.toBuilder() : null;
        }

        public final void setNamespaceIdentifier(NamespaceIdentifierUnion.BuilderImpl namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier != null ? namespaceIdentifier.build() : null;
        }

        @Override
        public final Builder namespaceIdentifier(NamespaceIdentifierUnion namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
            return this;
        }

        public final Collection<String> getConsumerIdentifiers() {
            if (this.consumerIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.consumerIdentifiers;
        }

        public final void setConsumerIdentifiers(Collection<String> consumerIdentifiers) {
            this.consumerIdentifiers = ConsumerIdentifierListCopier.copy(consumerIdentifiers);
        }

        @Override
        public final Builder consumerIdentifiers(Collection<String> consumerIdentifiers) {
            this.consumerIdentifiers = ConsumerIdentifierListCopier.copy(consumerIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerIdentifiers(String ... consumerIdentifiers) {
            this.consumerIdentifiers(Arrays.asList(consumerIdentifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterNamespaceRequest build() {
            return new DeregisterNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeregisterNamespaceRequest> {
        public Builder namespaceIdentifier(NamespaceIdentifierUnion var1);

        default public Builder namespaceIdentifier(Consumer<NamespaceIdentifierUnion.Builder> namespaceIdentifier) {
            return this.namespaceIdentifier((NamespaceIdentifierUnion)((NamespaceIdentifierUnion.Builder)NamespaceIdentifierUnion.builder().applyMutation(namespaceIdentifier)).build());
        }

        public Builder consumerIdentifiers(Collection<String> var1);

        public Builder consumerIdentifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

