/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterVersionsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DescribeClusterVersionsRequest> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterVersion").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::clusterVersion)).setter(DescribeClusterVersionsRequest.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()}).build();
    private static final SdkField<String> CLUSTER_PARAMETER_GROUP_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterParameterGroupFamily").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::clusterParameterGroupFamily)).setter(DescribeClusterVersionsRequest.setter(Builder::clusterParameterGroupFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroupFamily").build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::maxRecords)).setter(DescribeClusterVersionsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterVersionsRequest.getter(DescribeClusterVersionsRequest::marker)).setter(DescribeClusterVersionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD, CLUSTER_PARAMETER_GROUP_FAMILY_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClusterVersionsRequest.memberNameToFieldInitializer();
    private final String clusterVersion;
    private final String clusterParameterGroupFamily;
    private final Integer maxRecords;
    private final String marker;

    private DescribeClusterVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterVersion = builder.clusterVersion;
        this.clusterParameterGroupFamily = builder.clusterParameterGroupFamily;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final String clusterVersion() {
        return this.clusterVersion;
    }

    public final String clusterParameterGroupFamily() {
        return this.clusterParameterGroupFamily;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsRequest)) {
            return false;
        }
        DescribeClusterVersionsRequest other = (DescribeClusterVersionsRequest)((Object)obj);
        return Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.clusterParameterGroupFamily(), other.clusterParameterGroupFamily()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterVersionsRequest").add("ClusterVersion", (Object)this.clusterVersion()).add("ClusterParameterGroupFamily", (Object)this.clusterParameterGroupFamily()).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "ClusterParameterGroupFamily": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroupFamily()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterVersion", CLUSTER_VERSION_FIELD);
        map.put("ClusterParameterGroupFamily", CLUSTER_PARAMETER_GROUP_FAMILY_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsRequest, T> g) {
        return obj -> g.apply((DescribeClusterVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterParameterGroupFamily;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsRequest model) {
            super(model);
            this.clusterVersion(model.clusterVersion);
            this.clusterParameterGroupFamily(model.clusterParameterGroupFamily);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final String getClusterParameterGroupFamily() {
            return this.clusterParameterGroupFamily;
        }

        public final void setClusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
        }

        @Override
        public final Builder clusterParameterGroupFamily(String clusterParameterGroupFamily) {
            this.clusterParameterGroupFamily = clusterParameterGroupFamily;
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterVersionsRequest build() {
            return new DescribeClusterVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterVersionsRequest> {
        public Builder clusterVersion(String var1);

        public Builder clusterParameterGroupFamily(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

