/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResizeClusterRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ResizeClusterRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ResizeClusterRequest.getter(ResizeClusterRequest::clusterIdentifier)).setter(ResizeClusterRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(ResizeClusterRequest.getter(ResizeClusterRequest::clusterType)).setter(ResizeClusterRequest.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterType").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(ResizeClusterRequest.getter(ResizeClusterRequest::nodeType)).setter(ResizeClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(ResizeClusterRequest.getter(ResizeClusterRequest::numberOfNodes)).setter(ResizeClusterRequest.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<Boolean> CLASSIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Classic").getter(ResizeClusterRequest.getter(ResizeClusterRequest::classic)).setter(ResizeClusterRequest.setter(Builder::classic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classic").build()}).build();
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeId").getter(ResizeClusterRequest.getter(ResizeClusterRequest::reservedNodeId)).setter(ResizeClusterRequest.setter(Builder::reservedNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()}).build();
    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetReservedNodeOfferingId").getter(ResizeClusterRequest.getter(ResizeClusterRequest::targetReservedNodeOfferingId)).setter(ResizeClusterRequest.setter(Builder::targetReservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, CLUSTER_TYPE_FIELD, NODE_TYPE_FIELD, NUMBER_OF_NODES_FIELD, CLASSIC_FIELD, RESERVED_NODE_ID_FIELD, TARGET_RESERVED_NODE_OFFERING_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResizeClusterRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String clusterType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final Boolean classic;
    private final String reservedNodeId;
    private final String targetReservedNodeOfferingId;

    private ResizeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.classic = builder.classic;
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String clusterType() {
        return this.clusterType;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public final Boolean classic() {
        return this.classic;
    }

    public final String reservedNodeId() {
        return this.reservedNodeId;
    }

    public final String targetReservedNodeOfferingId() {
        return this.targetReservedNodeOfferingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.classic());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeOfferingId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResizeClusterRequest)) {
            return false;
        }
        ResizeClusterRequest other = (ResizeClusterRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.classic(), other.classic()) && Objects.equals(this.reservedNodeId(), other.reservedNodeId()) && Objects.equals(this.targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId());
    }

    public final String toString() {
        return ToString.builder((String)"ResizeClusterRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ClusterType", (Object)this.clusterType()).add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("Classic", (Object)this.classic()).add("ReservedNodeId", (Object)this.reservedNodeId()).add("TargetReservedNodeOfferingId", (Object)this.targetReservedNodeOfferingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "Classic": {
                return Optional.ofNullable(clazz.cast(this.classic()));
            }
            case "ReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeId()));
            }
            case "TargetReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeOfferingId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("ClusterType", CLUSTER_TYPE_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("NumberOfNodes", NUMBER_OF_NODES_FIELD);
        map.put("Classic", CLASSIC_FIELD);
        map.put("ReservedNodeId", RESERVED_NODE_ID_FIELD);
        map.put("TargetReservedNodeOfferingId", TARGET_RESERVED_NODE_OFFERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResizeClusterRequest, T> g) {
        return obj -> g.apply((ResizeClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String clusterType;
        private String nodeType;
        private Integer numberOfNodes;
        private Boolean classic;
        private String reservedNodeId;
        private String targetReservedNodeOfferingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResizeClusterRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.classic(model.classic);
            this.reservedNodeId(model.reservedNodeId);
            this.targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Boolean getClassic() {
            return this.classic;
        }

        public final void setClassic(Boolean classic) {
            this.classic = classic;
        }

        @Override
        public final Builder classic(Boolean classic) {
            this.classic = classic;
            return this;
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final String getTargetReservedNodeOfferingId() {
            return this.targetReservedNodeOfferingId;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResizeClusterRequest build() {
            return new ResizeClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResizeClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder classic(Boolean var1);

        public Builder reservedNodeId(String var1);

        public Builder targetReservedNodeOfferingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

