/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.LogDestinationType;
import software.amazon.awssdk.services.redshift.model.LogTypeListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableLoggingRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, EnableLoggingRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(EnableLoggingRequest.getter(EnableLoggingRequest::clusterIdentifier)).setter(EnableLoggingRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(EnableLoggingRequest.getter(EnableLoggingRequest::bucketName)).setter(EnableLoggingRequest.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3KeyPrefix").getter(EnableLoggingRequest.getter(EnableLoggingRequest::s3KeyPrefix)).setter(EnableLoggingRequest.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDestinationType").getter(EnableLoggingRequest.getter(EnableLoggingRequest::logDestinationTypeAsString)).setter(EnableLoggingRequest.setter(Builder::logDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").build()}).build();
    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogExports").getter(EnableLoggingRequest.getter(EnableLoggingRequest::logExports)).setter(EnableLoggingRequest.setter(Builder::logExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_EXPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableLoggingRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String bucketName;
    private final String s3KeyPrefix;
    private final String logDestinationType;
    private final List<String> logExports;

    private EnableLoggingRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.logDestinationType = builder.logDestinationType;
        this.logExports = builder.logExports;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public final LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(this.logDestinationType);
    }

    public final String logDestinationTypeAsString() {
        return this.logDestinationType;
    }

    public final boolean hasLogExports() {
        return this.logExports != null && !(this.logExports instanceof SdkAutoConstructList);
    }

    public final List<String> logExports() {
        return this.logExports;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogExports() ? this.logExports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingRequest)) {
            return false;
        }
        EnableLoggingRequest other = (EnableLoggingRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.logDestinationTypeAsString(), other.logDestinationTypeAsString()) && this.hasLogExports() == other.hasLogExports() && Objects.equals(this.logExports(), other.logExports());
    }

    public final String toString() {
        return ToString.builder((String)"EnableLoggingRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("BucketName", (Object)this.bucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("LogDestinationType", (Object)this.logDestinationTypeAsString()).add("LogExports", this.hasLogExports() ? this.logExports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "S3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
            case "LogDestinationType": {
                return Optional.ofNullable(clazz.cast(this.logDestinationTypeAsString()));
            }
            case "LogExports": {
                return Optional.ofNullable(clazz.cast(this.logExports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("S3KeyPrefix", S3_KEY_PREFIX_FIELD);
        map.put("LogDestinationType", LOG_DESTINATION_TYPE_FIELD);
        map.put("LogExports", LOG_EXPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableLoggingRequest, T> g) {
        return obj -> g.apply((EnableLoggingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String bucketName;
        private String s3KeyPrefix;
        private String logDestinationType;
        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnableLoggingRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.bucketName(model.bucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.logDestinationType(model.logDestinationType);
            this.logExports(model.logExports);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final String getLogDestinationType() {
            return this.logDestinationType;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final Collection<String> getLogExports() {
            if (this.logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogTypeListCopier.copy(logExports);
        }

        @Override
        public final Builder logExports(Collection<String> logExports) {
            this.logExports = LogTypeListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(String ... logExports) {
            this.logExports(Arrays.asList(logExports));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableLoggingRequest build() {
            return new EnableLoggingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableLoggingRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder bucketName(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder logDestinationType(String var1);

        public Builder logDestinationType(LogDestinationType var1);

        public Builder logExports(Collection<String> var1);

        public Builder logExports(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

