/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateDataShareConsumerRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DisassociateDataShareConsumerRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataShareArn").getter(DisassociateDataShareConsumerRequest.getter(DisassociateDataShareConsumerRequest::dataShareArn)).setter(DisassociateDataShareConsumerRequest.setter(Builder::dataShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_ENTIRE_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisassociateEntireAccount").getter(DisassociateDataShareConsumerRequest.getter(DisassociateDataShareConsumerRequest::disassociateEntireAccount)).setter(DisassociateDataShareConsumerRequest.setter(Builder::disassociateEntireAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateEntireAccount").build()}).build();
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerArn").getter(DisassociateDataShareConsumerRequest.getter(DisassociateDataShareConsumerRequest::consumerArn)).setter(DisassociateDataShareConsumerRequest.setter(Builder::consumerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerArn").build()}).build();
    private static final SdkField<String> CONSUMER_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerRegion").getter(DisassociateDataShareConsumerRequest.getter(DisassociateDataShareConsumerRequest::consumerRegion)).setter(DisassociateDataShareConsumerRequest.setter(Builder::consumerRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD, DISASSOCIATE_ENTIRE_ACCOUNT_FIELD, CONSUMER_ARN_FIELD, CONSUMER_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DisassociateDataShareConsumerRequest.memberNameToFieldInitializer();
    private final String dataShareArn;
    private final Boolean disassociateEntireAccount;
    private final String consumerArn;
    private final String consumerRegion;

    private DisassociateDataShareConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.disassociateEntireAccount = builder.disassociateEntireAccount;
        this.consumerArn = builder.consumerArn;
        this.consumerRegion = builder.consumerRegion;
    }

    public final String dataShareArn() {
        return this.dataShareArn;
    }

    public final Boolean disassociateEntireAccount() {
        return this.disassociateEntireAccount;
    }

    public final String consumerArn() {
        return this.consumerArn;
    }

    public final String consumerRegion() {
        return this.consumerRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateEntireAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateDataShareConsumerRequest)) {
            return false;
        }
        DisassociateDataShareConsumerRequest other = (DisassociateDataShareConsumerRequest)((Object)obj);
        return Objects.equals(this.dataShareArn(), other.dataShareArn()) && Objects.equals(this.disassociateEntireAccount(), other.disassociateEntireAccount()) && Objects.equals(this.consumerArn(), other.consumerArn()) && Objects.equals(this.consumerRegion(), other.consumerRegion());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateDataShareConsumerRequest").add("DataShareArn", (Object)this.dataShareArn()).add("DisassociateEntireAccount", (Object)this.disassociateEntireAccount()).add("ConsumerArn", (Object)this.consumerArn()).add("ConsumerRegion", (Object)this.consumerRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataShareArn": {
                return Optional.ofNullable(clazz.cast(this.dataShareArn()));
            }
            case "DisassociateEntireAccount": {
                return Optional.ofNullable(clazz.cast(this.disassociateEntireAccount()));
            }
            case "ConsumerArn": {
                return Optional.ofNullable(clazz.cast(this.consumerArn()));
            }
            case "ConsumerRegion": {
                return Optional.ofNullable(clazz.cast(this.consumerRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataShareArn", DATA_SHARE_ARN_FIELD);
        map.put("DisassociateEntireAccount", DISASSOCIATE_ENTIRE_ACCOUNT_FIELD);
        map.put("ConsumerArn", CONSUMER_ARN_FIELD);
        map.put("ConsumerRegion", CONSUMER_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateDataShareConsumerRequest, T> g) {
        return obj -> g.apply((DisassociateDataShareConsumerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String dataShareArn;
        private Boolean disassociateEntireAccount;
        private String consumerArn;
        private String consumerRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateDataShareConsumerRequest model) {
            super(model);
            this.dataShareArn(model.dataShareArn);
            this.disassociateEntireAccount(model.disassociateEntireAccount);
            this.consumerArn(model.consumerArn);
            this.consumerRegion(model.consumerRegion);
        }

        public final String getDataShareArn() {
            return this.dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final Boolean getDisassociateEntireAccount() {
            return this.disassociateEntireAccount;
        }

        public final void setDisassociateEntireAccount(Boolean disassociateEntireAccount) {
            this.disassociateEntireAccount = disassociateEntireAccount;
        }

        @Override
        public final Builder disassociateEntireAccount(Boolean disassociateEntireAccount) {
            this.disassociateEntireAccount = disassociateEntireAccount;
            return this;
        }

        public final String getConsumerArn() {
            return this.consumerArn;
        }

        public final void setConsumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
        }

        @Override
        public final Builder consumerArn(String consumerArn) {
            this.consumerArn = consumerArn;
            return this;
        }

        public final String getConsumerRegion() {
            return this.consumerRegion;
        }

        public final void setConsumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
        }

        @Override
        public final Builder consumerRegion(String consumerRegion) {
            this.consumerRegion = consumerRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateDataShareConsumerRequest build() {
            return new DisassociateDataShareConsumerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateDataShareConsumerRequest> {
        public Builder dataShareArn(String var1);

        public Builder disassociateEntireAccount(Boolean var1);

        public Builder consumerArn(String var1);

        public Builder consumerRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

