/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.ScheduleState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterAssociatedToSchedule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterAssociatedToSchedule> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ClusterAssociatedToSchedule.getter(ClusterAssociatedToSchedule::clusterIdentifier)).setter(ClusterAssociatedToSchedule.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleAssociationState").getter(ClusterAssociatedToSchedule.getter(ClusterAssociatedToSchedule::scheduleAssociationStateAsString)).setter(ClusterAssociatedToSchedule.setter(Builder::scheduleAssociationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAssociationState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SCHEDULE_ASSOCIATION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterAssociatedToSchedule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterIdentifier;
    private final String scheduleAssociationState;

    private ClusterAssociatedToSchedule(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.scheduleAssociationState = builder.scheduleAssociationState;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final ScheduleState scheduleAssociationState() {
        return ScheduleState.fromValue(this.scheduleAssociationState);
    }

    public final String scheduleAssociationStateAsString() {
        return this.scheduleAssociationState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleAssociationStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAssociatedToSchedule)) {
            return false;
        }
        ClusterAssociatedToSchedule other = (ClusterAssociatedToSchedule)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.scheduleAssociationStateAsString(), other.scheduleAssociationStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterAssociatedToSchedule").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ScheduleAssociationState", (Object)this.scheduleAssociationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ScheduleAssociationState": {
                return Optional.ofNullable(clazz.cast(this.scheduleAssociationStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("ScheduleAssociationState", SCHEDULE_ASSOCIATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAssociatedToSchedule, T> g) {
        return obj -> g.apply((ClusterAssociatedToSchedule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String scheduleAssociationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAssociatedToSchedule model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.scheduleAssociationState(model.scheduleAssociationState);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getScheduleAssociationState() {
            return this.scheduleAssociationState;
        }

        public final void setScheduleAssociationState(String scheduleAssociationState) {
            this.scheduleAssociationState = scheduleAssociationState;
        }

        @Override
        public final Builder scheduleAssociationState(String scheduleAssociationState) {
            this.scheduleAssociationState = scheduleAssociationState;
            return this;
        }

        @Override
        public final Builder scheduleAssociationState(ScheduleState scheduleAssociationState) {
            this.scheduleAssociationState(scheduleAssociationState == null ? null : scheduleAssociationState.toString());
            return this;
        }

        public ClusterAssociatedToSchedule build() {
            return new ClusterAssociatedToSchedule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterAssociatedToSchedule> {
        public Builder clusterIdentifier(String var1);

        public Builder scheduleAssociationState(String var1);

        public Builder scheduleAssociationState(ScheduleState var1);
    }
}

