/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AccountAttribute;
import software.amazon.awssdk.services.redshift.model.AttributeListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAttributesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<List<AccountAttribute>> ACCOUNT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountAttributes").getter(DescribeAccountAttributesResponse.getter(DescribeAccountAttributesResponse::accountAttributes)).setter(DescribeAccountAttributesResponse.setter(Builder::accountAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAttributes").build(), ListTrait.builder().memberLocationName("AccountAttribute").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAttribute").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AccountAttributes", ACCOUNT_ATTRIBUTES_FIELD);
        }
    });
    private final List<AccountAttribute> accountAttributes;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountAttributes = builder.accountAttributes;
    }

    public final boolean hasAccountAttributes() {
        return this.accountAttributes != null && !(this.accountAttributes instanceof SdkAutoConstructList);
    }

    public final List<AccountAttribute> accountAttributes() {
        return this.accountAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountAttributes() ? this.accountAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse)((Object)obj);
        return this.hasAccountAttributes() == other.hasAccountAttributes() && Objects.equals(this.accountAttributes(), other.accountAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountAttributesResponse").add("AccountAttributes", this.hasAccountAttributes() ? this.accountAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAttributes": {
                return Optional.ofNullable(clazz.cast(this.accountAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<AccountAttribute> accountAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            this.accountAttributes(model.accountAttributes);
        }

        public final List<AccountAttribute.Builder> getAccountAttributes() {
            List<AccountAttribute.Builder> result = AttributeListCopier.copyToBuilder(this.accountAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAttributes(Collection<AccountAttribute.BuilderImpl> accountAttributes) {
            this.accountAttributes = AttributeListCopier.copyFromBuilder(accountAttributes);
        }

        @Override
        public final Builder accountAttributes(Collection<AccountAttribute> accountAttributes) {
            this.accountAttributes = AttributeListCopier.copy(accountAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(AccountAttribute ... accountAttributes) {
            this.accountAttributes(Arrays.asList(accountAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAttributes(Consumer<AccountAttribute.Builder> ... accountAttributes) {
            this.accountAttributes(Stream.of(accountAttributes).map(c -> (AccountAttribute)((AccountAttribute.Builder)AccountAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        public Builder accountAttributes(Collection<AccountAttribute> var1);

        public Builder accountAttributes(AccountAttribute ... var1);

        public Builder accountAttributes(Consumer<AccountAttribute.Builder> ... var1);
    }
}

