/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EligibleTracksToUpdateListCopier;
import software.amazon.awssdk.services.redshift.model.UpdateTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceTrack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceTrack> {
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceTrackName").getter(MaintenanceTrack.getter(MaintenanceTrack::maintenanceTrackName)).setter(MaintenanceTrack.setter(Builder::maintenanceTrackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build()}).build();
    private static final SdkField<String> DATABASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseVersion").getter(MaintenanceTrack.getter(MaintenanceTrack::databaseVersion)).setter(MaintenanceTrack.setter(Builder::databaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseVersion").build()}).build();
    private static final SdkField<List<UpdateTarget>> UPDATE_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpdateTargets").getter(MaintenanceTrack.getter(MaintenanceTrack::updateTargets)).setter(MaintenanceTrack.setter(Builder::updateTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargets").build(), ListTrait.builder().memberLocationName("UpdateTarget").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTarget").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACK_NAME_FIELD, DATABASE_VERSION_FIELD, UPDATE_TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MaintenanceTrackName", MAINTENANCE_TRACK_NAME_FIELD);
            this.put("DatabaseVersion", DATABASE_VERSION_FIELD);
            this.put("UpdateTargets", UPDATE_TARGETS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String maintenanceTrackName;
    private final String databaseVersion;
    private final List<UpdateTarget> updateTargets;

    private MaintenanceTrack(BuilderImpl builder) {
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.databaseVersion = builder.databaseVersion;
        this.updateTargets = builder.updateTargets;
    }

    public final String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public final String databaseVersion() {
        return this.databaseVersion;
    }

    public final boolean hasUpdateTargets() {
        return this.updateTargets != null && !(this.updateTargets instanceof SdkAutoConstructList);
    }

    public final List<UpdateTarget> updateTargets() {
        return this.updateTargets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateTargets() ? this.updateTargets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceTrack)) {
            return false;
        }
        MaintenanceTrack other = (MaintenanceTrack)obj;
        return Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.databaseVersion(), other.databaseVersion()) && this.hasUpdateTargets() == other.hasUpdateTargets() && Objects.equals(this.updateTargets(), other.updateTargets());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceTrack").add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("DatabaseVersion", (Object)this.databaseVersion()).add("UpdateTargets", this.hasUpdateTargets() ? this.updateTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "DatabaseVersion": {
                return Optional.ofNullable(clazz.cast(this.databaseVersion()));
            }
            case "UpdateTargets": {
                return Optional.ofNullable(clazz.cast(this.updateTargets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceTrack, T> g) {
        return obj -> g.apply((MaintenanceTrack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maintenanceTrackName;
        private String databaseVersion;
        private List<UpdateTarget> updateTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceTrack model) {
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.databaseVersion(model.databaseVersion);
            this.updateTargets(model.updateTargets);
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final String getDatabaseVersion() {
            return this.databaseVersion;
        }

        public final void setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        @Override
        public final Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public final List<UpdateTarget.Builder> getUpdateTargets() {
            List<UpdateTarget.Builder> result = EligibleTracksToUpdateListCopier.copyToBuilder(this.updateTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateTargets(Collection<UpdateTarget.BuilderImpl> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copyFromBuilder(updateTargets);
        }

        @Override
        public final Builder updateTargets(Collection<UpdateTarget> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(UpdateTarget ... updateTargets) {
            this.updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(Consumer<UpdateTarget.Builder> ... updateTargets) {
            this.updateTargets(Stream.of(updateTargets).map(c -> (UpdateTarget)((UpdateTarget.Builder)UpdateTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MaintenanceTrack build() {
            return new MaintenanceTrack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceTrack> {
        public Builder maintenanceTrackName(String var1);

        public Builder databaseVersion(String var1);

        public Builder updateTargets(Collection<UpdateTarget> var1);

        public Builder updateTargets(UpdateTarget ... var1);

        public Builder updateTargets(Consumer<UpdateTarget.Builder> ... var1);
    }
}

