/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeRedshiftIdcApplicationsResponse;
import software.amazon.awssdk.services.redshift.model.RedshiftIdcApplication;

public class DescribeRedshiftIdcApplicationsIterable
implements SdkIterable<DescribeRedshiftIdcApplicationsResponse> {
    private final RedshiftClient client;
    private final DescribeRedshiftIdcApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRedshiftIdcApplicationsIterable(RedshiftClient client, DescribeRedshiftIdcApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRedshiftIdcApplicationsResponseFetcher();
    }

    public Iterator<DescribeRedshiftIdcApplicationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RedshiftIdcApplication> redshiftIdcApplications() {
        Function<DescribeRedshiftIdcApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.redshiftIdcApplications() != null) {
                return response.redshiftIdcApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRedshiftIdcApplicationsResponseFetcher
    implements SyncPageFetcher<DescribeRedshiftIdcApplicationsResponse> {
        private DescribeRedshiftIdcApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRedshiftIdcApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeRedshiftIdcApplicationsResponse nextPage(DescribeRedshiftIdcApplicationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeRedshiftIdcApplicationsIterable.this.client.describeRedshiftIdcApplications(DescribeRedshiftIdcApplicationsIterable.this.firstRequest);
            }
            return DescribeRedshiftIdcApplicationsIterable.this.client.describeRedshiftIdcApplications((DescribeRedshiftIdcApplicationsRequest)((Object)DescribeRedshiftIdcApplicationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

