/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeUsageLimitsResponse;
import software.amazon.awssdk.services.redshift.model.UsageLimit;

public class DescribeUsageLimitsPublisher
implements SdkPublisher<DescribeUsageLimitsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeUsageLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeUsageLimitsPublisher(RedshiftAsyncClient client, DescribeUsageLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeUsageLimitsPublisher(RedshiftAsyncClient client, DescribeUsageLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeUsageLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeUsageLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UsageLimit> usageLimits() {
        Function<DescribeUsageLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.usageLimits() != null) {
                return response.usageLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeUsageLimitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeUsageLimitsResponseFetcher
    implements AsyncPageFetcher<DescribeUsageLimitsResponse> {
        private DescribeUsageLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeUsageLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeUsageLimitsResponse> nextPage(DescribeUsageLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeUsageLimitsPublisher.this.client.describeUsageLimits(DescribeUsageLimitsPublisher.this.firstRequest);
            }
            return DescribeUsageLimitsPublisher.this.client.describeUsageLimits((DescribeUsageLimitsRequest)((Object)DescribeUsageLimitsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

