/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public class DescribeReservedNodeOfferingsIterable
implements SdkIterable<DescribeReservedNodeOfferingsResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodeOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodeOfferingsIterable(RedshiftClient client, DescribeReservedNodeOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodeOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedNodeOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNodeOffering> reservedNodeOfferings() {
        Function<DescribeReservedNodeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeOfferings() != null) {
                return response.reservedNodeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedNodeOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodeOfferingsResponse> {
        private DescribeReservedNodeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedNodeOfferingsResponse nextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeOfferingsIterable.this.client.describeReservedNodeOfferings(DescribeReservedNodeOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedNodeOfferingsIterable.this.client.describeReservedNodeOfferings((DescribeReservedNodeOfferingsRequest)((Object)DescribeReservedNodeOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

