/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevision;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterDbRevisionsResponse;

public class DescribeClusterDbRevisionsPublisher
implements SdkPublisher<DescribeClusterDbRevisionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterDbRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterDbRevisionsPublisher(RedshiftAsyncClient client, DescribeClusterDbRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterDbRevisionsPublisher(RedshiftAsyncClient client, DescribeClusterDbRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterDbRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterDbRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterDbRevision> clusterDbRevisions() {
        Function<DescribeClusterDbRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterDbRevisions() != null) {
                return response.clusterDbRevisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterDbRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClusterDbRevisionsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterDbRevisionsResponse> {
        private DescribeClusterDbRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterDbRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterDbRevisionsResponse> nextPage(DescribeClusterDbRevisionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterDbRevisionsPublisher.this.client.describeClusterDbRevisions(DescribeClusterDbRevisionsPublisher.this.firstRequest);
            }
            return DescribeClusterDbRevisionsPublisher.this.client.describeClusterDbRevisions((DescribeClusterDbRevisionsRequest)((Object)DescribeClusterDbRevisionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

