/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroup;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroupListCopier;
import software.amazon.awssdk.services.redshift.model.IPRange;
import software.amazon.awssdk.services.redshift.model.IPRangeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSecurityGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSecurityGroup> {
    private static final SdkField<String> CLUSTER_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSecurityGroupName").getter(ClusterSecurityGroup.getter(ClusterSecurityGroup::clusterSecurityGroupName)).setter(ClusterSecurityGroup.setter(Builder::clusterSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterSecurityGroup.getter(ClusterSecurityGroup::description)).setter(ClusterSecurityGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2SecurityGroups").getter(ClusterSecurityGroup.getter(ClusterSecurityGroup::ec2SecurityGroups)).setter(ClusterSecurityGroup.setter(Builder::ec2SecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(), ListTrait.builder().memberLocationName("EC2SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2SecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<IPRange>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IPRanges").getter(ClusterSecurityGroup.getter(ClusterSecurityGroup::ipRanges)).setter(ClusterSecurityGroup.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRanges").build(), ListTrait.builder().memberLocationName("IPRange").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRange").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ClusterSecurityGroup.getter(ClusterSecurityGroup::tags)).setter(ClusterSecurityGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SECURITY_GROUP_NAME_FIELD, DESCRIPTION_FIELD, EC2_SECURITY_GROUPS_FIELD, IP_RANGES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterSecurityGroupName;
    private final String description;
    private final List<EC2SecurityGroup> ec2SecurityGroups;
    private final List<IPRange> ipRanges;
    private final List<Tag> tags;

    private ClusterSecurityGroup(BuilderImpl builder) {
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.description = builder.description;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.tags = builder.tags;
    }

    public final String clusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SecurityGroups() {
        return this.ec2SecurityGroups != null && !(this.ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<EC2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<IPRange> ipRanges() {
        return this.ipRanges;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSecurityGroup)) {
            return false;
        }
        ClusterSecurityGroup other = (ClusterSecurityGroup)obj;
        return Objects.equals(this.clusterSecurityGroupName(), other.clusterSecurityGroupName()) && Objects.equals(this.description(), other.description()) && this.hasEc2SecurityGroups() == other.hasEc2SecurityGroups() && Objects.equals(this.ec2SecurityGroups(), other.ec2SecurityGroups()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSecurityGroup").add("ClusterSecurityGroupName", (Object)this.clusterSecurityGroupName()).add("Description", (Object)this.description()).add("EC2SecurityGroups", this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null).add("IPRanges", this.hasIpRanges() ? this.ipRanges() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EC2SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroups()));
            }
            case "IPRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSecurityGroup, T> g) {
        return obj -> g.apply((ClusterSecurityGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterSecurityGroupName;
        private String description;
        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<IPRange> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSecurityGroup model) {
            this.clusterSecurityGroupName(model.clusterSecurityGroupName);
            this.description(model.description);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
            this.ipRanges(model.ipRanges);
            this.tags(model.tags);
        }

        public final String getClusterSecurityGroupName() {
            return this.clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final List<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            List<EC2SecurityGroup.Builder> result = EC2SecurityGroupListCopier.copyToBuilder(this.ec2SecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> (EC2SecurityGroup)((EC2SecurityGroup.Builder)EC2SecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        public final List<IPRange.Builder> getIpRanges() {
            List<IPRange.Builder> result = IPRangeListCopier.copyToBuilder(this.ipRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(IPRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<IPRange.Builder> ... ipRanges) {
            this.ipRanges(Stream.of(ipRanges).map(c -> (IPRange)((IPRange.Builder)IPRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<IPRange.BuilderImpl> ipRanges) {
            this.ipRanges = IPRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ClusterSecurityGroup build() {
            return new ClusterSecurityGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSecurityGroup> {
        public Builder clusterSecurityGroupName(String var1);

        public Builder description(String var1);

        public Builder ec2SecurityGroups(Collection<EC2SecurityGroup> var1);

        public Builder ec2SecurityGroups(EC2SecurityGroup ... var1);

        public Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder> ... var1);

        public Builder ipRanges(Collection<IPRange> var1);

        public Builder ipRanges(IPRange ... var1);

        public Builder ipRanges(Consumer<IPRange.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

