/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A tag and its associated resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaggedResource implements SdkPojo, Serializable, ToCopyableBuilder<TaggedResource.Builder, TaggedResource> {
    private static final SdkField<Tag> TAG_FIELD = SdkField.<Tag> builder(MarshallingType.SDK_POJO).memberName("Tag")
            .getter(getter(TaggedResource::tag)).setter(setter(Builder::tag)).constructor(Tag::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(TaggedResource::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(TaggedResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FIELD,
            RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Tag tag;

    private final String resourceName;

    private final String resourceType;

    private TaggedResource(BuilderImpl builder) {
        this.tag = builder.tag;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    /**
     * <p>
     * The tag for the resource.
     * </p>
     * 
     * @return The tag for the resource.
     */
    public final Tag tag() {
        return tag;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) with which the tag is associated, for example:
     * <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) with which the tag is associated, for example:
     *         <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of resource with which the tag is associated. Valid resource types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Cluster
     * </p>
     * </li>
     * <li>
     * <p>
     * CIDR/IP
     * </p>
     * </li>
     * <li>
     * <p>
     * EC2 security group
     * </p>
     * </li>
     * <li>
     * <p>
     * Snapshot
     * </p>
     * </li>
     * <li>
     * <p>
     * Cluster security group
     * </p>
     * </li>
     * <li>
     * <p>
     * Subnet group
     * </p>
     * </li>
     * <li>
     * <p>
     * HSM connection
     * </p>
     * </li>
     * <li>
     * <p>
     * HSM certificate
     * </p>
     * </li>
     * <li>
     * <p>
     * Parameter group
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Amazon Redshift resource types and constructing ARNs, go to <a href=
     * "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions"
     * >Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management Guide.
     * </p>
     * 
     * @return The type of resource with which the tag is associated. Valid resource types are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Cluster
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CIDR/IP
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EC2 security group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Snapshot
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cluster security group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Subnet group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HSM connection
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         HSM certificate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Parameter group
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about Amazon Redshift resource types and constructing ARNs, go to <a href=
     *         "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions"
     *         >Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management
     *         Guide.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedResource)) {
            return false;
        }
        TaggedResource other = (TaggedResource) obj;
        return Objects.equals(tag(), other.tag()) && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaggedResource").add("Tag", tag()).add("ResourceName", resourceName())
                .add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaggedResource, T> g) {
        return obj -> g.apply((TaggedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaggedResource> {
        /**
         * <p>
         * The tag for the resource.
         * </p>
         * 
         * @param tag
         *        The tag for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(Tag tag);

        /**
         * <p>
         * The tag for the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link Tag.Builder} avoiding the need to create one
         * manually via {@link Tag#builder()}.
         *
         * When the {@link Consumer} completes, {@link Tag.Builder#build()} is called immediately and its result is
         * passed to {@link #tag(Tag)}.
         * 
         * @param tag
         *        a consumer that will call methods on {@link Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(Tag)
         */
        default Builder tag(Consumer<Tag.Builder> tag) {
            return tag(Tag.builder().applyMutation(tag).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) with which the tag is associated, for example:
         * <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.
         * </p>
         * 
         * @param resourceName
         *        The Amazon Resource Name (ARN) with which the tag is associated, for example:
         *        <code>arn:aws:redshift:us-east-2:123456789:cluster:t1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of resource with which the tag is associated. Valid resource types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Cluster
         * </p>
         * </li>
         * <li>
         * <p>
         * CIDR/IP
         * </p>
         * </li>
         * <li>
         * <p>
         * EC2 security group
         * </p>
         * </li>
         * <li>
         * <p>
         * Snapshot
         * </p>
         * </li>
         * <li>
         * <p>
         * Cluster security group
         * </p>
         * </li>
         * <li>
         * <p>
         * Subnet group
         * </p>
         * </li>
         * <li>
         * <p>
         * HSM connection
         * </p>
         * </li>
         * <li>
         * <p>
         * HSM certificate
         * </p>
         * </li>
         * <li>
         * <p>
         * Parameter group
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about Amazon Redshift resource types and constructing ARNs, go to <a href=
         * "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions"
         * >Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster Management
         * Guide.
         * </p>
         * 
         * @param resourceType
         *        The type of resource with which the tag is associated. Valid resource types are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Cluster
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CIDR/IP
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EC2 security group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Snapshot
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cluster security group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Subnet group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HSM connection
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        HSM certificate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Parameter group
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about Amazon Redshift resource types and constructing ARNs, go to <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-overview.html#redshift-iam-access-control-specify-actions"
         *        >Constructing an Amazon Redshift Amazon Resource Name (ARN)</a> in the Amazon Redshift Cluster
         *        Management Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private Tag tag;

        private String resourceName;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(TaggedResource model) {
            tag(model.tag);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
        }

        public final Tag.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final String getResourceName() {
            return resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public TaggedResource build() {
            return new TaggedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
