/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHsmConfigurationsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeHsmConfigurationsResponse.Builder, DescribeHsmConfigurationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeHsmConfigurationsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<HsmConfiguration>> HSM_CONFIGURATIONS_FIELD = SdkField
            .<List<HsmConfiguration>> builder(MarshallingType.LIST)
            .memberName("HsmConfigurations")
            .getter(getter(DescribeHsmConfigurationsResponse::hsmConfigurations))
            .setter(setter(Builder::hsmConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("HsmConfiguration")
                            .memberFieldInfo(
                                    SdkField.<HsmConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HsmConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("HsmConfiguration").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            HSM_CONFIGURATIONS_FIELD));

    private final String marker;

    private final List<HsmConfiguration> hsmConfigurations;

    private DescribeHsmConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.hsmConfigurations = builder.hsmConfigurations;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the HsmConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHsmConfigurations() {
        return hsmConfigurations != null && !(hsmConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>HsmConfiguration</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHsmConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>HsmConfiguration</code> objects.
     */
    public final List<HsmConfiguration> hsmConfigurations() {
        return hsmConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasHsmConfigurations() ? hsmConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmConfigurationsResponse)) {
            return false;
        }
        DescribeHsmConfigurationsResponse other = (DescribeHsmConfigurationsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasHsmConfigurations() == other.hasHsmConfigurations()
                && Objects.equals(hsmConfigurations(), other.hsmConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHsmConfigurationsResponse").add("Marker", marker())
                .add("HsmConfigurations", hasHsmConfigurations() ? hsmConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "HsmConfigurations":
            return Optional.ofNullable(clazz.cast(hsmConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeHsmConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHsmConfigurationsResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>HsmConfiguration</code> objects.
         * </p>
         * 
         * @param hsmConfigurations
         *        A list of <code>HsmConfiguration</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurations(Collection<HsmConfiguration> hsmConfigurations);

        /**
         * <p>
         * A list of <code>HsmConfiguration</code> objects.
         * </p>
         * 
         * @param hsmConfigurations
         *        A list of <code>HsmConfiguration</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hsmConfigurations(HsmConfiguration... hsmConfigurations);

        /**
         * <p>
         * A list of <code>HsmConfiguration</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HsmConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<HsmConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HsmConfiguration>.Builder#build()} is called immediately and
         * its result is passed to {@link #hsmConfigurations(List<HsmConfiguration>)}.
         * 
         * @param hsmConfigurations
         *        a consumer that will call methods on {@link List<HsmConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hsmConfigurations(List<HsmConfiguration>)
         */
        Builder hsmConfigurations(Consumer<HsmConfiguration.Builder>... hsmConfigurations);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<HsmConfiguration> hsmConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmConfigurationsResponse model) {
            super(model);
            marker(model.marker);
            hsmConfigurations(model.hsmConfigurations);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmConfiguration.Builder> getHsmConfigurations() {
            if (hsmConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return hsmConfigurations != null ? hsmConfigurations.stream().map(HsmConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsmConfigurations(Collection<HsmConfiguration> hsmConfigurations) {
            this.hsmConfigurations = HsmConfigurationListCopier.copy(hsmConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmConfigurations(HsmConfiguration... hsmConfigurations) {
            hsmConfigurations(Arrays.asList(hsmConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmConfigurations(Consumer<HsmConfiguration.Builder>... hsmConfigurations) {
            hsmConfigurations(Stream.of(hsmConfigurations).map(c -> HsmConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHsmConfigurations(Collection<HsmConfiguration.BuilderImpl> hsmConfigurations) {
            this.hsmConfigurations = HsmConfigurationListCopier.copyFromBuilder(hsmConfigurations);
        }

        @Override
        public DescribeHsmConfigurationsResponse build() {
            return new DescribeHsmConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
