/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptReservedNodeExchangeRequest extends RedshiftRequest implements
        ToCopyableBuilder<AcceptReservedNodeExchangeRequest.Builder, AcceptReservedNodeExchangeRequest> {
    private static final SdkField<String> RESERVED_NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedNodeId").getter(getter(AcceptReservedNodeExchangeRequest::reservedNodeId))
            .setter(setter(Builder::reservedNodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeId").build()).build();

    private static final SdkField<String> TARGET_RESERVED_NODE_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetReservedNodeOfferingId")
            .getter(getter(AcceptReservedNodeExchangeRequest::targetReservedNodeOfferingId))
            .setter(setter(Builder::targetReservedNodeOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetReservedNodeOfferingId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_ID_FIELD,
            TARGET_RESERVED_NODE_OFFERING_ID_FIELD));

    private final String reservedNodeId;

    private final String targetReservedNodeOfferingId;

    private AcceptReservedNodeExchangeRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
    }

    /**
     * <p>
     * A string representing the node identifier of the DC1 Reserved Node to be exchanged.
     * </p>
     * 
     * @return A string representing the node identifier of the DC1 Reserved Node to be exchanged.
     */
    public final String reservedNodeId() {
        return reservedNodeId;
    }

    /**
     * <p>
     * The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value for
     * the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
     * </p>
     * 
     * @return The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the
     *         value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
     */
    public final String targetReservedNodeOfferingId() {
        return targetReservedNodeOfferingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(targetReservedNodeOfferingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedNodeExchangeRequest)) {
            return false;
        }
        AcceptReservedNodeExchangeRequest other = (AcceptReservedNodeExchangeRequest) obj;
        return Objects.equals(reservedNodeId(), other.reservedNodeId())
                && Objects.equals(targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptReservedNodeExchangeRequest").add("ReservedNodeId", reservedNodeId())
                .add("TargetReservedNodeOfferingId", targetReservedNodeOfferingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeId":
            return Optional.ofNullable(clazz.cast(reservedNodeId()));
        case "TargetReservedNodeOfferingId":
            return Optional.ofNullable(clazz.cast(targetReservedNodeOfferingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptReservedNodeExchangeRequest, T> g) {
        return obj -> g.apply((AcceptReservedNodeExchangeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AcceptReservedNodeExchangeRequest> {
        /**
         * <p>
         * A string representing the node identifier of the DC1 Reserved Node to be exchanged.
         * </p>
         * 
         * @param reservedNodeId
         *        A string representing the node identifier of the DC1 Reserved Node to be exchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeId(String reservedNodeId);

        /**
         * <p>
         * The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain the value
         * for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
         * </p>
         * 
         * @param targetReservedNodeOfferingId
         *        The unique identifier of the DC2 Reserved Node offering to be used for the exchange. You can obtain
         *        the value for the parameter by calling <a>GetReservedNodeExchangeOfferings</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String reservedNodeId;

        private String targetReservedNodeOfferingId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptReservedNodeExchangeRequest model) {
            super(model);
            reservedNodeId(model.reservedNodeId);
            targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
        }

        public final String getReservedNodeId() {
            return reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        public final String getTargetReservedNodeOfferingId() {
            return targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptReservedNodeExchangeRequest build() {
            return new AcceptReservedNodeExchangeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
